/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.whitelist;

import java.io.File;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.server.management.WhiteList;
import net.minecraft.server.management.WhitelistEntry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.accessor.server.management.UserListEntryAccessor;
import org.spongepowered.common.profile.SpongeGameProfile;

public class SpongeUserListWhitelist
extends WhiteList {
    public SpongeUserListWhitelist(File file) {
        super(file);
    }

    protected boolean hasEntry(com.mojang.authlib.GameProfile entry) {
        return Sponge.getServer().getServiceProvider().whitelistService().isWhitelisted(SpongeGameProfile.of(entry));
    }

    public String[] getKeys() {
        ArrayList names = new ArrayList();
        for (GameProfile profile : Sponge.getServer().getServiceProvider().whitelistService().getWhitelistedProfiles()) {
            profile.getName().ifPresent(names::add);
        }
        return names.toArray(new String[names.size()]);
    }

    public void addEntry(WhitelistEntry entry) {
        Sponge.getServer().getServiceProvider().whitelistService().addProfile((GameProfile)((UserListEntryAccessor)entry).accessor$getValue());
    }

    public void removeEntry(com.mojang.authlib.GameProfile entry) {
        Sponge.getServer().getServiceProvider().whitelistService().removeProfile(SpongeGameProfile.of(entry));
    }

    public boolean isEmpty() {
        return Sponge.getServer().getServiceProvider().whitelistService().getWhitelistedProfiles().isEmpty();
    }

    @Nullable
    public com.mojang.authlib.GameProfile getByName(String profileName) {
        for (GameProfile profile : Sponge.getServer().getServiceProvider().whitelistService().getWhitelistedProfiles()) {
            if (!profile.getName().isPresent() || !profile.getName().get().equals(profileName)) continue;
            return (com.mojang.authlib.GameProfile)profile;
        }
        return null;
    }
}

