/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.Range;

public final class SpongeRange<T extends Number>
implements Range<T> {
    private final @Nullable T min;
    private final @Nullable T max;

    public SpongeRange(@Nullable T min2, @Nullable T max) {
        if (min2 == null && max == null) {
            throw new IllegalArgumentException("At least one of min or max must not be null.");
        }
        this.min = min2;
        this.max = max;
    }

    @Override
    public @Nullable T getMin() {
        return this.min;
    }

    @Override
    public @Nullable T getMax() {
        return this.max;
    }

    public static final class Factory
    implements Range.Factory {
        @Override
        public @NonNull Range<@NonNull Integer> intRange(@Nullable Integer min2, @Nullable Integer max) {
            if (min2 != null && max != null && max > min2) {
                throw new IllegalArgumentException("min must be smaller or equal to max if both are defined");
            }
            return new SpongeRange<Integer>(min2, max);
        }

        @Override
        public @NonNull Range<@NonNull Double> doubleRange(@Nullable Double min2, @Nullable Double max) {
            if (min2 != null && max != null && max > min2) {
                throw new IllegalArgumentException("min must be smaller or equal to max if both are defined");
            }
            return new SpongeRange<Double>(min2, max);
        }
    }
}

