/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.base.MoreObjects;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;

public final class SpongeBlockChangeFlag
implements BlockChangeFlag {
    private final boolean updateNeighbors;
    private final boolean notifyClients;
    private final boolean performBlockPhysics;
    private final boolean notifyObservers;
    private final boolean ignoreRender;
    private final boolean forceReRender;
    private final boolean blockMoving;
    private final boolean lighting;
    private final boolean pathfindingUpdates;
    private final boolean neighborDrops;
    private final int rawFlag;
    private final String name;

    public SpongeBlockChangeFlag(String name, int flag) {
        this.updateNeighbors = (flag & 1) != 0;
        this.notifyClients = (flag & 2) != 0;
        this.ignoreRender = (flag & 4) != 0;
        this.forceReRender = (flag & 8) != 0 && !this.ignoreRender;
        this.notifyObservers = (flag & 0x10) == 0;
        this.neighborDrops = (flag & 0x20) != 0;
        this.blockMoving = (flag & 0x40) != 0;
        this.performBlockPhysics = (flag & 0x80) == 0;
        this.lighting = (flag & 0x100) == 0;
        this.pathfindingUpdates = (flag & 0x200) == 0;
        this.rawFlag = flag;
        this.name = name;
    }

    @Override
    public boolean updateNeighbors() {
        return this.updateNeighbors;
    }

    @Override
    public boolean notifyClients() {
        return this.notifyClients;
    }

    @Override
    public boolean performBlockPhysics() {
        return this.performBlockPhysics;
    }

    @Override
    public boolean notifyObservers() {
        return this.notifyObservers;
    }

    @Override
    public boolean updateLighting() {
        return this.lighting;
    }

    @Override
    public boolean notifyPathfinding() {
        return this.pathfindingUpdates;
    }

    @Override
    public SpongeBlockChangeFlag withUpdateNeighbors(boolean updateNeighbors) {
        if (this.updateNeighbors == updateNeighbors) {
            return this;
        }
        int maskedFlag = (updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.notifyObservers ? 0 : 16) | (this.neighborDrops ? 32 : 0) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 128) | (this.lighting ? 0 : 256) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag withNotifyClients(boolean notifyClients) {
        if (this.notifyClients == notifyClients) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.notifyObservers ? 0 : 16) | (this.neighborDrops ? 32 : 0) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 128) | (this.lighting ? 0 : 256) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag withPhysics(boolean performBlockPhysics) {
        if (this.performBlockPhysics == performBlockPhysics) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.notifyObservers ? 0 : 16) | (this.neighborDrops ? 32 : 0) | (this.blockMoving ? 64 : 0) | (performBlockPhysics ? 0 : 128) | (this.lighting ? 0 : 256) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag withNotifyObservers(boolean notifyObservers) {
        if (this.notifyObservers == notifyObservers) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (notifyObservers ? 0 : 16) | (this.neighborDrops ? 32 : 0) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 128) | (this.lighting ? 0 : 256) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public BlockChangeFlag withLightingUpdates(boolean lighting) {
        if (this.lighting == lighting) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.notifyObservers ? 0 : 16) | (this.neighborDrops ? 32 : 0) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 128) | (lighting ? 0 : 256) | (this.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public BlockChangeFlag withPathfindingUpdates(boolean pathfindingUpdates) {
        if (this.pathfindingUpdates == pathfindingUpdates) {
            return this;
        }
        int maskedFlag = (this.updateNeighbors ? 1 : 0) | (this.notifyClients ? 2 : 0) | (this.ignoreRender ? 4 : 0) | (this.forceReRender ? 8 : 0) | (this.notifyObservers ? 0 : 16) | (this.neighborDrops ? 32 : 0) | (this.blockMoving ? 64 : 0) | (this.performBlockPhysics ? 0 : 128) | (this.lighting ? 0 : 256) | (pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public BlockChangeFlag inverse() {
        int maskedFlag = (this.updateNeighbors ? 0 : 1) | (this.notifyClients ? 0 : 2) | (this.ignoreRender ? 0 : 4) | (this.forceReRender ? 0 : 8) | (this.notifyObservers ? 16 : 0) | (this.neighborDrops ? 0 : 32) | (this.blockMoving ? 0 : 64) | (this.performBlockPhysics ? 128 : 0) | (this.lighting ? 256 : 0) | (this.pathfindingUpdates ? 512 : 0);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag andFlag(BlockChangeFlag flag) {
        SpongeBlockChangeFlag o = (SpongeBlockChangeFlag)flag;
        int maskedFlag = (this.updateNeighbors || o.updateNeighbors ? 1 : 0) | (this.notifyClients || o.notifyClients ? 2 : 0) | (this.ignoreRender || o.ignoreRender ? 4 : 0) | (this.forceReRender || o.forceReRender ? 8 : 0) | (this.notifyObservers || o.notifyObservers ? 0 : 16) | (this.neighborDrops || o.neighborDrops ? 32 : 0) | (this.blockMoving || o.blockMoving ? 64 : 0) | (this.performBlockPhysics || o.performBlockPhysics ? 0 : 128) | (this.lighting || o.lighting ? 0 : 256) | (this.pathfindingUpdates || o.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    @Override
    public SpongeBlockChangeFlag andNotFlag(BlockChangeFlag flag) {
        SpongeBlockChangeFlag o = (SpongeBlockChangeFlag)flag;
        int maskedFlag = (this.updateNeighbors && !o.updateNeighbors) | (this.notifyClients && !o.notifyClients ? 2 : 0) | (this.ignoreRender && !o.ignoreRender ? 4 : 0) | (this.forceReRender && !o.forceReRender ? 8 : 0) | (this.notifyObservers && !o.notifyObservers ? 0 : 16) | (this.neighborDrops && !o.neighborDrops ? 32 : 0) | (this.blockMoving && !o.blockMoving ? 64 : 0) | (this.performBlockPhysics && !o.performBlockPhysics ? 0 : 128) | (this.lighting && !o.lighting ? 0 : 256) | (this.pathfindingUpdates && !o.pathfindingUpdates ? 0 : 512);
        return BlockChangeFlagManager.fromNativeInt(maskedFlag);
    }

    public boolean isIgnoreRender() {
        return this.ignoreRender;
    }

    public boolean isForceReRender() {
        return this.forceReRender;
    }

    public boolean isBlockMoving() {
        return this.blockMoving;
    }

    public boolean neighborDrops() {
        return this.neighborDrops;
    }

    public String getName() {
        return this.name;
    }

    public int getRawFlag() {
        return this.rawFlag;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rawFlag", this.rawFlag).add("notifyNeighbors", this.updateNeighbors).add("notifyClients", this.notifyClients).add("performBlockPhysics", this.performBlockPhysics).add("notifyObservers", this.notifyObservers).add("ignoreRender", this.ignoreRender).add("forceReRender", this.forceReRender).toString();
    }
}

