/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.SpongeLocatableBlock;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeLocatableBlockBuilder
extends AbstractDataBuilder<LocatableBlock>
implements LocatableBlock.Builder {
    Supplier<? extends BlockState> blockState;
    Supplier<? extends ResourceKey> world;
    Supplier<? extends Vector3i> position;
    Supplier<? extends ServerWorld> worldReference;

    public SpongeLocatableBlockBuilder() {
        super(LocatableBlock.class, 1);
    }

    @Override
    public SpongeLocatableBlockBuilder state(BlockState blockState) {
        Objects.requireNonNull(blockState, "BlockState cannot be null!");
        this.blockState = () -> blockState;
        return this;
    }

    @Override
    public SpongeLocatableBlockBuilder location(ServerLocation location) {
        Objects.requireNonNull(location, "LocationBridge cannot be null!");
        this.blockState = location::getBlock;
        this.position = location::getBlockPosition;
        this.world = () -> ((ServerWorld)location.getWorld()).getKey();
        WeakReference worldRef = new WeakReference(location.getWorld());
        this.worldReference = () -> (ServerWorld)Objects.requireNonNull(worldRef.get(), "ServerWorld refrence dereferenced");
        return this;
    }

    @Override
    public SpongeLocatableBlockBuilder position(Vector3i position) {
        Objects.requireNonNull(position, "Position cannot be null!");
        this.position = () -> position;
        return this;
    }

    @Override
    public SpongeLocatableBlockBuilder position(int x, int y, int z) {
        Vector3i position = new Vector3i(x, y, z);
        this.position = () -> position;
        return this;
    }

    public SpongeLocatableBlockBuilder world(Supplier<net.minecraft.world.server.ServerWorld> worldSupplier) {
        Objects.requireNonNull(worldSupplier, "Supplier cannot be null!");
        Objects.requireNonNull(worldSupplier.get(), "ServerWorld reference cannot be null!");
        this.worldReference = worldSupplier;
        this.world = () -> ((ServerWorld)worldSupplier.get()).getKey();
        return this;
    }

    @Override
    public SpongeLocatableBlockBuilder world(ServerWorld world) {
        Objects.requireNonNull(world, "World cannot be null!");
        WeakReference<ServerWorld> reference = new WeakReference<ServerWorld>(world);
        this.worldReference = () -> (ServerWorld)Objects.requireNonNull(reference.get(), "ServerWorld refrence dereferenced");
        this.world = () -> this.worldReference.get().getKey();
        return this;
    }

    @Override
    public SpongeLocatableBlockBuilder from(LocatableBlock value) {
        Objects.requireNonNull(value, "LocatableBlock cannot be null!");
        this.position = value::getBlockPosition;
        this.world = () -> ((ServerWorld)value.getServerLocation().getWorld()).getKey();
        WeakReference worldRef = new WeakReference(value.getServerLocation().getWorld());
        this.worldReference = () -> (ServerWorld)Objects.requireNonNull(worldRef.get(), "ServerWorld refrence dereferenced");
        return this;
    }

    @Override
    public LocatableBlock build() {
        Objects.requireNonNull(this.position, "Position cannot be null!");
        Objects.requireNonNull(this.world, "World UUID cannot be null!");
        Objects.requireNonNull(this.worldReference, "World reference cannot be null!");
        return new SpongeLocatableBlock(this);
    }

    @Override
    public SpongeLocatableBlockBuilder reset() {
        this.position = null;
        this.world = null;
        this.worldReference = null;
        this.blockState = null;
        return this;
    }

    @Override
    protected Optional<LocatableBlock> buildContent(DataView container) throws InvalidDataException {
        ResourceKey worldKey = container.getKey(Queries.WORLD_KEY).orElseThrow(() -> new InvalidDataException("Could not locate a world key"));
        int x = container.getInt(Queries.POSITION_X).orElseThrow(() -> new InvalidDataException("Could not locate an \"x\" coordinate in the container!"));
        int y = container.getInt(Queries.POSITION_Y).orElseThrow(() -> new InvalidDataException("Could not locate an \"y\" coordinate in the container!"));
        int z = container.getInt(Queries.POSITION_Z).orElseThrow(() -> new InvalidDataException("Could not locate an \"z\" coordinate in the container!"));
        BlockState blockState = container.getSerializable(Constants.Block.BLOCK_STATE, BlockState.class).orElseThrow(() -> new InvalidDataException("Could not locate a BlockState"));
        return Sponge.getServer().getWorldManager().getWorld(worldKey).map(world -> new SpongeLocatableBlockBuilder().position(x, y, z).world((ServerWorld)world).state(blockState).build());
    }
}

