/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.border;

import java.time.Duration;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.math.vector.Vector3d;

public class SpongeWorldBorderBuilder
implements WorldBorder.Builder {
    private double diameter;
    private Vector3d center = Vector3d.ZERO;
    private Duration warningTime;
    private double warningDistance;
    private double damageThreshold;
    private double damageAmount;

    @Override
    public WorldBorder.Builder from(WorldBorder border) {
        this.diameter = border.getDiameter();
        this.center = border.getCenter();
        this.warningTime = border.getWarningTime();
        this.warningDistance = border.getWarningDistance();
        this.damageThreshold = border.getDamageThreshold();
        this.damageAmount = border.getDamageAmount();
        return this;
    }

    @Override
    public WorldBorder.Builder diameter(double diameter) {
        this.diameter = diameter;
        return this;
    }

    @Override
    public WorldBorder.Builder center(double x, double z) {
        this.center = new Vector3d(x, 0.0, z);
        return this;
    }

    @Override
    public WorldBorder.Builder warningTime(Duration time) {
        this.warningTime = time;
        return this;
    }

    @Override
    public WorldBorder.Builder warningDistance(double distance) {
        this.warningDistance = distance;
        return this;
    }

    @Override
    public WorldBorder.Builder damageThreshold(double distance) {
        this.damageThreshold = distance;
        return this;
    }

    @Override
    public WorldBorder.Builder damageAmount(double damage) {
        this.damageAmount = damage;
        return this;
    }

    @Override
    public WorldBorder build() throws IllegalStateException {
        net.minecraft.world.border.WorldBorder border = new net.minecraft.world.border.WorldBorder();
        border.setCenter(this.center.getX(), this.center.getZ());
        border.setDamagePerBlock(this.damageAmount);
        border.setDamageBuffer(this.damageThreshold);
        border.setTransition(this.diameter);
        border.setWarningDistance((int)this.warningDistance);
        border.setWarningTime((int)this.warningTime.getSeconds());
        return (WorldBorder)border;
    }

    @Override
    public WorldBorder.Builder reset() {
        this.center = Vector3d.ZERO;
        this.damageAmount = 0.0;
        this.damageThreshold = 0.0;
        this.diameter = 0.0;
        this.warningDistance = 0.0;
        this.warningTime = Duration.ZERO;
        return this;
    }
}

