/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.Teleporter;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.portal.Portal;
import org.spongepowered.api.world.portal.PortalType;
import org.spongepowered.common.bridge.world.PlatformITeleporterBridge;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.portal.PortalHelper;

public final class WrappedITeleporterPortalType
implements PortalType {
    private final ResourceKey key = ResourceKey.sponge("unknown");
    private final PlatformITeleporterBridge teleporter;
    private final PortalType logicType;

    public WrappedITeleporterPortalType(PlatformITeleporterBridge teleporter, @Nullable PortalType logicType) {
        this.teleporter = teleporter;
        this.logicType = logicType;
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }

    @Override
    public void generatePortal(ServerLocation location) {
        if (this.logicType != null) {
            this.logicType.generatePortal(location);
        } else if (this.teleporter instanceof Teleporter) {
            Teleporter teleporter = (Teleporter)this.teleporter;
        }
    }

    @Override
    public Optional<Portal> findPortal(ServerLocation location) {
        if (this.logicType != null) {
            return this.logicType.findPortal(location);
        }
        return Optional.empty();
    }

    @Override
    public boolean teleport(org.spongepowered.api.entity.Entity entity, ServerLocation destination, boolean generateDestinationPortal) {
        Entity result;
        ServerLocation currentLocation = entity.getServerLocation();
        if (this.logicType != null) {
            Function<Boolean, Entity> portalLogic = entity instanceof ServerPlayer ? PortalHelper.createVanillaPlayerPortalLogic((ServerPlayerEntity)entity, VecHelper.toVec3d(destination.getPosition()), (ServerWorld)entity.getServerLocation().getWorld(), (ServerWorld)destination.getWorld(), this) : PortalHelper.createVanillaEntityPortalLogic((Entity)entity, VecHelper.toVec3d(destination.getPosition()), (ServerWorld)entity.getServerLocation().getWorld(), (ServerWorld)destination.getWorld(), this);
            result = portalLogic.apply(generateDestinationPortal);
        } else {
            result = entity instanceof ServerPlayer ? this.teleporter.bridge$placeEntity((Entity)((ServerPlayerEntity)entity), (ServerWorld)entity.getWorld(), (ServerWorld)destination.getWorld(), 0.0f, PortalHelper.createVanillaPlayerPortalLogic((ServerPlayerEntity)entity, VecHelper.toVec3d(destination.getPosition()), (ServerWorld)entity.getWorld(), (ServerWorld)destination.getWorld(), this)) : this.teleporter.bridge$placeEntity((Entity)entity, (ServerWorld)entity.getWorld(), (ServerWorld)destination.getWorld(), 0.0f, PortalHelper.createVanillaEntityPortalLogic((Entity)entity, VecHelper.toVec3d(destination.getPosition()), (ServerWorld)entity.getWorld(), (ServerWorld)destination.getWorld(), this));
        }
        if (result == null) {
            return false;
        }
        if (result instanceof ServerPlayerEntity) {
            return !currentLocation.equals(((org.spongepowered.api.entity.Entity)result).getServerLocation());
        }
        return true;
    }

    public PortalType getLogicType() {
        return this.logicType;
    }

    public PlatformITeleporterBridge getTeleporter() {
        return this.teleporter;
    }
}

