/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.common.world.schematic.ImmutableBimapPalette;

public class MutableBimapPalette<T>
implements Palette.Mutable<T> {
    private static final int DEFAULT_ALLOCATION_SIZE = 64;
    private final BiMap<Integer, T> ids;
    private final BiMap<T, Integer> idsr;
    private final BitSet allocation = new BitSet(64);
    private final PaletteType<T> paletteType;
    private int maxId = 0;

    public MutableBimapPalette(PaletteType<T> paletteType) {
        this.ids = HashBiMap.create();
        this.idsr = this.ids.inverse();
        this.paletteType = paletteType;
    }

    public MutableBimapPalette(PaletteType<T> paletteType, BiMap<T, Integer> reference) {
        this.ids = HashBiMap.create((int)reference.size());
        this.idsr = this.ids.inverse();
        this.paletteType = paletteType;
        reference.forEach((key, id) -> this.getOrAssign((T)key));
    }

    public MutableBimapPalette(PaletteType<T> paletteType, int expectedSize) {
        this.ids = HashBiMap.create((int)expectedSize);
        this.idsr = this.ids.inverse();
        this.paletteType = paletteType;
    }

    @Override
    public PaletteType<T> getType() {
        return this.paletteType;
    }

    @Override
    public int getHighestId() {
        return this.maxId;
    }

    @Override
    public OptionalInt get(T state) {
        Integer value = (Integer)this.idsr.get(state);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    @Override
    public int getOrAssign(T state) {
        Integer id = (Integer)this.idsr.get(state);
        if (id == null) {
            int next = this.allocation.nextClearBit(0);
            if (this.maxId < next) {
                this.maxId = next;
            }
            this.allocation.set(next);
            this.ids.put((Object)next, state);
            return next;
        }
        return id;
    }

    @Override
    public Optional<T> get(int id) {
        return Optional.ofNullable(this.ids.get((Object)id));
    }

    public void assign(T state, int id) {
        if (this.maxId < id) {
            this.maxId = id;
        }
        this.allocation.set(id);
        this.ids.put((Object)id, state);
    }

    @Override
    public boolean remove(T state) {
        Integer id = (Integer)this.idsr.get(state);
        if (id == null) {
            return false;
        }
        this.allocation.clear(id);
        if (id == this.maxId) {
            this.maxId = this.allocation.previousSetBit(this.maxId);
        }
        this.ids.remove((Object)id);
        return true;
    }

    @Override
    public Stream<T> stream() {
        return this.idsr.keySet().stream();
    }

    @Override
    public Palette.Immutable<T> asImmutable() {
        return new ImmutableBimapPalette<T>(this.paletteType, this.ids);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableBimapPalette that = (MutableBimapPalette)o;
        return this.maxId == that.maxId && this.ids.equals(that.ids) && this.allocation.equals(that.allocation) && this.paletteType.equals(that.paletteType);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.allocation, this.paletteType, this.maxId);
    }
}

