/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.dimension.DimensionType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;

public final class WorldRegistration {
    private final ResourceKey key;
    private @Nullable DimensionType dimensionType;
    private @Nullable WorldSettings defaultSettings;

    public WorldRegistration(ResourceKey key, @Nullable DimensionType dimensionType, @Nullable WorldSettings defaultSettings) {
        this.key = Objects.requireNonNull(key);
        this.dimensionType = dimensionType;
        this.defaultSettings = defaultSettings;
    }

    public ResourceKey getKey() {
        return this.key;
    }

    public @Nullable DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public @Nullable WorldSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    public void setDimensionType(@Nullable DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public void setDimensionType(@Nullable WorldSettings defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        WorldRegistration that = (WorldRegistration)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("dimensionType", (Object)this.dimensionType).toString();
    }
}

