/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume;

import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.game.ReadableRegion;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.math.vector.Vector3i;

public final class VolumeStreamUtils {
    private VolumeStreamUtils() {
    }

    public static <T> Supplier<T> createWeaklyReferencedSupplier(T object, String name) {
        WeakReference weakReference = new WeakReference(object);
        return () -> {
            @Nullable T weaklyReferenced = weakReference.get();
            return Objects.requireNonNull(weaklyReferenced, () -> String.format("%s de-referenced!", name));
        };
    }

    public static <R extends ReadableRegion<R>> BiFunction<R, ChunkPos, @Nullable IChunk> getChunkAccessorByStatus(IWorldReader worldReader, boolean shouldGenerate) {
        return (world, chunkPos) -> {
            ChunkStatus chunkStatus = shouldGenerate ? ChunkStatus.FULL : ChunkStatus.EMPTY;
            @Nullable IChunk ichunk = worldReader.getChunk(chunkPos.x, chunkPos.z, chunkStatus, shouldGenerate);
            if (shouldGenerate) {
                Objects.requireNonNull(ichunk, "Chunk was expected to load fully and generate, but somehow got a null chunk!");
            }
            return ichunk;
        };
    }

    public static Function<IChunk, Stream<Map.Entry<BlockPos, Biome>>> getBiomesForChunkByPos(Vector3i min2, Vector3i max) {
        return VolumeStreamUtils.getElementByPosition(VolumeStreamUtils.chunkSectionBiomeGetter(), min2, max);
    }

    public static Function<IChunk, Stream<Map.Entry<BlockPos, BlockState>>> getBlockStatesForSections(Vector3i min2, Vector3i max) {
        return VolumeStreamUtils.getElementByPosition(VolumeStreamUtils.chunkSectionBlockStateGetter(), min2, max);
    }

    public static void validateStreamArgs(Vector3i min2, Vector3i max, StreamOptions options) {
        Objects.requireNonNull(min2, "Minimum coordinates cannot be null");
        Objects.requireNonNull(max, "Maximum coordinates cannot be null");
        Objects.requireNonNull(options, "StreamOptions cannot be null!");
        if (min2.getX() > max.getX()) {
            throw new IllegalArgumentException("Min(x) must be greater than max(x)!");
        }
        if (min2.getY() > max.getY()) {
            throw new IllegalArgumentException("Min(y) must be greater than max y!");
        }
        if (min2.getZ() > max.getZ()) {
            throw new IllegalArgumentException("Min(z) must be greater than max z!");
        }
    }

    public static void validateStreamArgs(Vector3i min2, Vector3i max, Vector3i existingMin, Vector3i existingMax, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, options);
        if (existingMin.compareTo(Objects.requireNonNull(min2, "Minimum coordinates cannot be null!")) < 0) {
            throw new IllegalArgumentException(String.format("Minimum %s cannot be lower than the current minimum coordinates: %s", min2, existingMin));
        }
        if (existingMax.compareTo(Objects.requireNonNull(max, "Minimum coordinates cannot be null!")) < 0) {
            throw new IllegalArgumentException(String.format("Maximum %s cannot be greater than the current maximum coordinates: %s", max, existingMax));
        }
    }

    private static TriFunction<IChunk, ChunkSection, BlockPos, Biome> chunkSectionBiomeGetter() {
        return (chunk, chunkSection, pos) -> {
            if (chunk.getBiomes() == null) {
                if (chunk instanceof Chunk) {
                    return ((Chunk)chunk).getWorld().getNoiseBiomeRaw(pos.getX(), pos.getY(), pos.getZ());
                }
                return Biomes.OCEAN;
            }
            return chunk.getBiomes().getNoiseBiome(pos.getX(), pos.getY(), pos.getZ());
        };
    }

    private static TriFunction<IChunk, ChunkSection, BlockPos, BlockState> chunkSectionBlockStateGetter() {
        return (chunk, chunkSection, pos) -> chunkSection.getBlockState(pos.getX() - (chunk.getPos().x << 4), pos.getY() & 0xF, pos.getZ() - (chunk.getPos().z << 4));
    }

    private static <T> Function<IChunk, Stream<Map.Entry<BlockPos, T>>> getElementByPosition(TriFunction<IChunk, ChunkSection, BlockPos, T> elementAccessor, Vector3i min2, Vector3i max) {
        int minChunkX = min2.getX() >> 4;
        int minXOffset = min2.getX() & 0xF;
        int minChunkZ = min2.getZ() >> 4;
        int minZOffset = min2.getZ() & 0xF;
        int minYSection = min2.getY() >> 4 << 4;
        int minYOffset = min2.getY() & 0xF;
        int maxChunkX = max.getX() >> 4;
        int maxXOffset = max.getX() & 0xF;
        int maxChunkZ = max.getZ() >> 4;
        int maxZOffset = max.getZ() & 0xF;
        int maxYSection = max.getY() >> 4 << 4;
        int maxYOffset = max.getY() & 0xF;
        return chunk -> {
            ChunkPos pos = chunk.getPos();
            int xStart = pos.x == minChunkX ? minXOffset : 0;
            int xEnd = pos.x == maxChunkX ? maxXOffset + 1 : 16;
            int zStart = pos.z == minChunkZ ? minZOffset : 0;
            int zEnd = pos.z == maxChunkZ ? maxZOffset + 1 : 16;
            return Arrays.stream(chunk.getSections()).filter(Objects::nonNull).filter(chunkSection -> chunkSection.getYLocation() >= minYSection && chunkSection.getYLocation() <= maxYSection).flatMap(chunkSection -> IntStream.range(zStart, zEnd).mapToObj(z -> IntStream.range(xStart, xEnd).mapToObj(x -> {
                int sectionY = chunkSection.getYLocation();
                int yStart = sectionY == minYSection ? minYOffset : 0;
                int yEnd = sectionY == maxYSection ? maxYOffset + 1 : 16;
                return IntStream.range(yStart, yEnd).mapToObj(y -> {
                    BlockPos blockPos = new BlockPos(x + (pos.x << 4), y + sectionY, z + (pos.z << 4));
                    return new AbstractMap.SimpleEntry(blockPos, elementAccessor.apply((IChunk)chunk, (ChunkSection)chunkSection, blockPos));
                });
            })).flatMap(Function.identity()).flatMap(Function.identity()));
        };
    }

    public static <R extends Volume, API, MC, Section, KeyReference> VolumeStream<R, API> generateStream(Vector3i min2, Vector3i max, StreamOptions options, R ref, BiConsumer<KeyReference, MC> identityFunction, BiFunction<R, ChunkPos, Section> chunkAccessor, BiFunction<BlockPos, MC, KeyReference> entityToKey, Function<Section, Stream<Map.Entry<BlockPos, MC>>> entityAccessor, BiFunction<KeyReference, R, Tuple<BlockPos, MC>> filteredPositionEntityAccessor) {
        Stream<Object> filteredPosStream;
        Supplier worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(ref, "World");
        BlockPos chunkMin = new BlockPos(min2.getX() >> 4, 0, min2.getZ() >> 4);
        BlockPos chunkMax = new BlockPos(max.getX() >> 4, 0, max.getZ() >> 4);
        Stream<Object> chunkPosStream = IntStream.range(chunkMin.getX(), chunkMax.getX() + 1).mapToObj(x -> IntStream.range(chunkMin.getZ(), chunkMax.getZ() + 1).mapToObj(z -> new ChunkPos(x, z))).flatMap(Function.identity());
        Function<Tuple, VolumeElement> elementGenerator = tuple -> {
            Supplier<Object> blockEntitySupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(tuple.getB(), "Element");
            Vector3i blockEntityPos = VecHelper.toVector3i((BlockPos)tuple.getA());
            return VolumeElement.of(worldSupplier, blockEntitySupplier, blockEntityPos);
        };
        BiConsumer<Map.Entry, Set> entryConsumer = (entry, poses) -> {
            BlockPos pos = (BlockPos)entry.getKey();
            Vector3i v = VecHelper.toVector3i(pos);
            Object keyRef = entityToKey.apply(pos, entry.getValue());
            poses.add(keyRef);
            identityFunction.accept(keyRef, entry.getValue());
        };
        if (options.loadingStyle().immediateLoading()) {
            LinkedHashSet availableTileEntityPositions = new LinkedHashSet();
            chunkPosStream.map(pos -> chunkAccessor.apply(ref, (ChunkPos)pos)).map(entityAccessor).forEach(map -> map.forEach(entry -> entryConsumer.accept((Map.Entry)entry, availableTileEntityPositions)));
            filteredPosStream = availableTileEntityPositions.stream();
        } else {
            filteredPosStream = chunkPosStream.flatMap(chunkPos -> {
                LinkedHashSet blockEntityPoses = new LinkedHashSet();
                ((Stream)entityAccessor.apply(chunkAccessor.apply(ref, (ChunkPos)chunkPos))).forEach(entry -> entryConsumer.accept((Map.Entry)entry, blockEntityPoses));
                return blockEntityPoses.stream();
            });
        }
        Stream volumeStreamBacker = filteredPosStream.map(pos -> (Tuple)filteredPositionEntityAccessor.apply(pos, ref)).filter(tuple -> Objects.nonNull(tuple.getB())).map(elementGenerator);
        return new SpongeVolumeStream(volumeStreamBacker, worldSupplier);
    }

    private static interface TriFunction<A, B, C, Out> {
        public Out apply(A var1, B var2, C var3);
    }
}

