/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer;

import java.util.Objects;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

public class AbstractObjectArrayBuffer
implements Volume {
    protected final Vector3i start;
    protected final Vector3i size;
    protected final Vector3i end;
    private final int yLine;
    private final int yzSlice;

    public AbstractObjectArrayBuffer(Vector3i start, Vector3i size) {
        this.start = start;
        this.size = size;
        this.end = this.start.add(this.size).sub(Vector3i.ONE);
        this.yLine = size.getY();
        this.yzSlice = this.yLine * size.getZ();
    }

    protected void checkRange(int x, int y, int z) {
        if (!VecHelper.inBounds(x, y, z, this.start, this.end)) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)this.start, (Vectori)this.end);
        }
    }

    protected int getIndex(int x, int y, int z) {
        return (x - this.start.getX()) * this.yzSlice + (z - this.start.getZ()) * this.yLine + (y - this.start.getY());
    }

    @Override
    public Vector3i getBlockMax() {
        return this.end;
    }

    @Override
    public Vector3i getBlockMin() {
        return this.start;
    }

    @Override
    public Vector3i getBlockSize() {
        return this.size;
    }

    @Override
    public boolean containsBlock(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, this.start, this.end);
    }

    @Override
    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, this.start, this.end);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractObjectArrayBuffer that = (AbstractObjectArrayBuffer)o;
        return this.yLine == that.yLine && this.yzSlice == that.yzSlice && this.start.equals((Object)that.start) && this.size.equals((Object)that.size) && this.end.equals((Object)that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.size, this.end, this.yLine, this.yzSlice);
    }

    public String toString() {
        return new StringJoiner(", ", AbstractObjectArrayBuffer.class.getSimpleName() + "[", "]").add("start=" + this.start).add("end=" + this.end).toString();
    }
}

