/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.biome;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.volume.biome.ImmutableBiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.AbstractBiomeBuffer;
import org.spongepowered.math.vector.Vector3i;

public final class ByteArrayImmutableBiomeBuffer
extends AbstractBiomeBuffer
implements ImmutableBiomeVolume {
    private final byte[] biomes;
    private final Palette<BiomeType> palette;

    public ByteArrayImmutableBiomeBuffer(Palette<BiomeType> palette, byte[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = (byte[])biomes.clone();
        this.palette = palette;
    }

    private ByteArrayImmutableBiomeBuffer(Palette<BiomeType> palette, Vector3i start, Vector3i size, byte[] biomes) {
        super(start, size);
        this.biomes = biomes;
        this.palette = palette;
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.palette.get(this.biomes[this.getIndex(x, y, z)]).orElseGet(BiomeTypes.OCEAN);
    }

    public static ImmutableBiomeVolume newWithoutArrayClone(byte[] biomes, Vector3i start, Vector3i size) {
        return new ByteArrayImmutableBiomeBuffer(GlobalPalette.getBiomePalette(), start, size, biomes);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ByteArrayImmutableBiomeBuffer that = (ByteArrayImmutableBiomeBuffer)o;
        return Arrays.equals(this.biomes, that.biomes) && this.palette.equals(that.palette);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.palette);
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }

    @Override
    public VolumeStream<ImmutableBiomeVolume, BiomeType> getBiomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        Stream stateStream = IntStream.range(blockMin.getX(), blockMax.getX() + 1).mapToObj(x -> IntStream.range(blockMin.getZ(), blockMax.getZ() + 1).mapToObj(z -> IntStream.range(blockMin.getY(), blockMax.getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> {
            byte biomeId = this.biomes[this.getIndex(x, y, z)];
            return this.palette.get(biomeId & 0xFF).orElseGet(BiomeTypes.OCEAN);
        }, new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ImmutableBiomeVolume, BiomeType>(stateStream, () -> this);
    }
}

