/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.chat;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public final class ChatFormatter {
    private static final String DEFAULT_SCHEME = "http://";
    private static final String SCHEME = "https?://";
    private static final String IP_ADDRESS = "(?:\\d{1,3}\\.){3}\\d{1,3}";
    private static final String DOMAIN = "(?:[a-z\\d](?:[a-z\\d-]*[a-z\\d])?\\.)+[a-z](?:[a-z\\d-]*[a-z\\d])?";
    private static final String PORT = "\\d{1,5}";
    private static final String PATH = ".*?";
    private static final Pattern URL_PATTERN = Pattern.compile("(?:https?://)?(?:(?:\\d{1,3}\\.){3}\\d{1,3}|(?:[a-z\\d](?:[a-z\\d-]*[a-z\\d])?\\.)+[a-z](?:[a-z\\d-]*[a-z\\d])?)(?::\\d{1,5})?.*?(?=[!?,;:\"']?(?:[\u00a7\\s]|$))", 2);

    private ChatFormatter() {
    }

    public static void formatChatComponent(TranslationTextComponent component) {
        String message = (String)component.getFormatArgs()[1];
        ITextComponent formatted = ChatFormatter.format(message);
        if (formatted == null) {
            return;
        }
        formatted.getStyle().setParentStyle(component.getStyle());
        component.getFormatArgs()[1] = formatted;
    }

    @Nullable
    public static ITextComponent format(String s2) {
        Matcher matcher = URL_PATTERN.matcher(s2);
        if (!matcher.find()) {
            return null;
        }
        StringTextComponent result = null;
        int pos = 0;
        do {
            String url;
            String displayUrl;
            int end;
            int start;
            block11: {
                start = matcher.start();
                end = matcher.end();
                url = displayUrl = s2.substring(start, end);
                try {
                    if (new URI(url).getScheme() != null) break block11;
                    url = DEFAULT_SCHEME + url;
                }
                catch (URISyntaxException e) {
                    continue;
                }
            }
            if (pos < start) {
                if (result == null) {
                    result = new StringTextComponent(s2.substring(pos, start));
                } else {
                    result.appendText(s2.substring(pos, start));
                }
            }
            pos = end;
            StringTextComponent link = new StringTextComponent(displayUrl);
            link.getStyle().setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
            if (result == null) {
                result = new StringTextComponent("");
            }
            result.appendSibling((ITextComponent)link);
        } while (matcher.find());
        if (pos < s2.length()) {
            if (result == null) {
                result = new StringTextComponent(s2.substring(pos));
            } else {
                result.appendText(s2.substring(pos));
            }
        }
        return result;
    }
}

