/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public abstract class ScrollPanel
extends FocusableGui
implements IRenderable {
    private final Minecraft client;
    protected final int width;
    protected final int height;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    private boolean scrolling;
    protected float scrollDistance;
    protected final int border = 4;
    private final int barWidth = 6;
    private final int barLeft;

    public ScrollPanel(Minecraft client, int width, int height, int top, int left) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - 6;
    }

    protected abstract int getContentHeight();

    protected void drawBackground() {
    }

    protected abstract void drawPanel(int var1, int var2, Tessellator var3, int var4, int var5);

    protected boolean clickPanel(double mouseX, double mouseY, int button) {
        return false;
    }

    private int getMaxScroll() {
        return this.getContentHeight() - (this.height - this.border);
    }

    private void applyScrollLimits() {
        int max = Math.max(0, this.getMaxScroll());
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)max) {
            this.scrollDistance = max;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (scroll != 0.0) {
            this.scrollDistance = (float)((double)this.scrollDistance + -scroll * (double)this.getScrollAmount());
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    protected int getScrollAmount() {
        return 20;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseX <= (double)(this.left + this.width) && mouseY >= (double)this.top && mouseY <= (double)this.bottom;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        boolean bl = this.scrolling = button == 0 && mouseX >= (double)this.barLeft && mouseX < (double)(this.barLeft + 6);
        if (this.scrolling) {
            return true;
        }
        int mouseListY = (int)mouseY - this.top - this.getContentHeight() + (int)this.scrollDistance - 4;
        if (mouseX >= (double)this.left && mouseX <= (double)this.right && mouseListY < 0) {
            return this.clickPanel(mouseX - (double)this.left, mouseY - (double)this.top + (double)((int)this.scrollDistance) - 4.0, button);
        }
        return false;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_)) {
            return true;
        }
        boolean ret = this.scrolling;
        this.scrolling = false;
        return ret;
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - 8) {
            barHeight = this.height - 8;
        }
        return barHeight;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int maxScroll = this.height - this.getBarHeight();
            double moved = deltaY / (double)maxScroll;
            this.scrollDistance = (float)((double)this.scrollDistance + (double)this.getMaxScroll() * moved);
            this.applyScrollLimits();
            return true;
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.drawBackground();
        Tessellator tess = Tessellator.getInstance();
        BufferBuilder worldr = tess.getBuffer();
        double scale = this.client.getMainWindow().getGuiScaleFactor();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.client.getMainWindow().getFramebufferHeight() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        GlStateManager.disableLighting();
        GlStateManager.disableFog();
        this.client.getTextureManager().bindTexture(AbstractGui.BACKGROUND_LOCATION);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float texScale = 32.0f;
        worldr.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
        worldr.pos((double)this.left, (double)this.bottom, 0.0).tex((float)this.left / 32.0f, (float)(this.bottom + (int)this.scrollDistance) / 32.0f).color(32, 32, 32, 255).endVertex();
        worldr.pos((double)this.right, (double)this.bottom, 0.0).tex((float)this.right / 32.0f, (float)(this.bottom + (int)this.scrollDistance) / 32.0f).color(32, 32, 32, 255).endVertex();
        worldr.pos((double)this.right, (double)this.top, 0.0).tex((float)this.right / 32.0f, (float)(this.top + (int)this.scrollDistance) / 32.0f).color(32, 32, 32, 255).endVertex();
        worldr.pos((double)this.left, (double)this.top, 0.0).tex((float)this.left / 32.0f, (float)(this.top + (int)this.scrollDistance) / 32.0f).color(32, 32, 32, 255).endVertex();
        tess.draw();
        int baseY = this.top + 4 - (int)this.scrollDistance;
        this.drawPanel(this.right, baseY, tess, mouseX, mouseY);
        GlStateManager.disableDepthTest();
        int extraHeight = this.getContentHeight() + 4 - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            GlStateManager.disableTexture();
            worldr.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            worldr.pos((double)this.barLeft, (double)this.bottom, 0.0).tex(0.0f, 1.0f).color(0, 0, 0, 255).endVertex();
            worldr.pos((double)(this.barLeft + 6), (double)this.bottom, 0.0).tex(1.0f, 1.0f).color(0, 0, 0, 255).endVertex();
            worldr.pos((double)(this.barLeft + 6), (double)this.top, 0.0).tex(1.0f, 0.0f).color(0, 0, 0, 255).endVertex();
            worldr.pos((double)this.barLeft, (double)this.top, 0.0).tex(0.0f, 0.0f).color(0, 0, 0, 255).endVertex();
            tess.draw();
            worldr.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            worldr.pos((double)this.barLeft, (double)(barTop + barHeight), 0.0).tex(0.0f, 1.0f).color(128, 128, 128, 255).endVertex();
            worldr.pos((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).tex(1.0f, 1.0f).color(128, 128, 128, 255).endVertex();
            worldr.pos((double)(this.barLeft + 6), (double)barTop, 0.0).tex(1.0f, 0.0f).color(128, 128, 128, 255).endVertex();
            worldr.pos((double)this.barLeft, (double)barTop, 0.0).tex(0.0f, 0.0f).color(128, 128, 128, 255).endVertex();
            tess.draw();
            worldr.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
            worldr.pos((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).tex(0.0f, 1.0f).color(192, 192, 192, 255).endVertex();
            worldr.pos((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).tex(1.0f, 1.0f).color(192, 192, 192, 255).endVertex();
            worldr.pos((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).tex(1.0f, 0.0f).color(192, 192, 192, 255).endVertex();
            worldr.pos((double)this.barLeft, (double)barTop, 0.0).tex(0.0f, 0.0f).color(192, 192, 192, 255).endVertex();
            tess.draw();
        }
        GlStateManager.enableTexture();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.enableAlphaTest();
        GlStateManager.disableBlend();
        GL11.glDisable((int)3089);
    }

    public List<? extends IGuiEventListener> children() {
        return Collections.emptyList();
    }
}

