/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.world;

import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.profiler.IProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.biome.FuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.CommandStorage;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.dimension.DimensionTypes;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.accessor.util.registry.SimpleRegistryAccessor;
import org.spongepowered.common.accessor.world.dimension.DimensionTypeAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.WorldSettingsBridge;
import org.spongepowered.common.bridge.world.dimension.DimensionTypeBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.event.lifecycle.RegisterWorldEventImpl;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.FutureUtil;
import org.spongepowered.common.world.dimension.SpongeDimensionType;
import org.spongepowered.common.world.server.SpongeWorldManager;
import org.spongepowered.common.world.server.WorldRegistration;
import org.spongepowered.vanilla.accessor.server.MinecraftServerAccessor_Vanilla;
import org.spongepowered.vanilla.accessor.world.storage.SaveFormatAccessor_Vanilla;
import org.spongepowered.vanilla.bridge.util.registry.SimpleRegistryBridge;

public final class VanillaWorldManager
implements SpongeWorldManager {
    private final MinecraftServer server;
    private final Path savesDirectory;
    private final Map<ResourceKey, net.minecraft.world.server.ServerWorld> worlds;
    private final Map<DimensionType, net.minecraft.world.server.ServerWorld> worldsByType;
    private final Map<ResourceKey, WorldInfo> loadedWorldInfos;
    private final Map<DimensionType, WorldInfo> infoByType;
    private final Map<ResourceKey, WorldRegistration> pendingWorlds;
    private final Map<ResourceKey, WorldInfo> allInfos;
    private static final TicketType<ResourceLocation> SPAWN_CHUNKS = TicketType.create((String)"spawn_chunks", (i, o) -> i.compareTo(o));

    public VanillaWorldManager(MinecraftServer server) {
        this.server = server;
        this.savesDirectory = ((MinecraftServerAccessor_Vanilla)server).accessor$getAnvilFile().toPath().resolve(server.getFolderName());
        this.worlds = new Object2ObjectOpenHashMap();
        this.worldsByType = ((MinecraftServerAccessor_Vanilla)server).accessor$getWorlds();
        this.loadedWorldInfos = new Object2ObjectOpenHashMap();
        this.infoByType = new IdentityHashMap<DimensionType, WorldInfo>();
        this.pendingWorlds = new LinkedHashMap<ResourceKey, WorldRegistration>();
        this.allInfos = new LinkedHashMap<ResourceKey, WorldInfo>();
        this.clearCustomWorldDimensions();
        this.registerPendingWorld(SpongeWorldManager.VANILLA_OVERWORLD, null);
        this.registerPendingWorld(SpongeWorldManager.VANILLA_THE_NETHER, null);
        this.registerPendingWorld(SpongeWorldManager.VANILLA_THE_END, null);
    }

    @Override
    public Path getSavesDirectory() {
        return this.savesDirectory;
    }

    @Override
    public Optional<ServerWorld> getWorld(ResourceKey key) {
        Objects.requireNonNull(key);
        return Optional.ofNullable(this.worlds.get(key));
    }

    @Override
    public Collection<ServerWorld> getWorlds() {
        return Collections.unmodifiableCollection(this.worldsByType.values());
    }

    @Override
    public ResourceKey getDefaultPropertiesKey() {
        return VANILLA_OVERWORLD;
    }

    @Override
    public Optional<WorldProperties> getDefaultProperties() {
        net.minecraft.world.server.ServerWorld defaultWorld = this.getDefaultWorld();
        if (defaultWorld == null) {
            return Optional.empty();
        }
        return Optional.of((WorldProperties)defaultWorld.getWorldInfo());
    }

    @Override
    public CompletableFuture<WorldProperties> createProperties(ResourceKey key, WorldArchetype archetype) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(archetype);
        WorldInfo worldInfo = new WorldInfo((WorldSettings)archetype, key.getValue());
        ((ResourceKeyBridge)worldInfo).bridge$setKey(key);
        ((WorldInfoBridge)worldInfo).bridge$setUniqueId(UUID.randomUUID());
        ((WorldInfoBridge)worldInfo).bridge$setModCreated(true);
        SpongeCommon.postEvent(SpongeEventFactory.createConstructWorldPropertiesEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), archetype, (WorldProperties)worldInfo));
        return CompletableFuture.completedFuture((WorldProperties)worldInfo);
    }

    @Override
    public CompletableFuture<ServerWorld> loadWorld(ResourceKey key) {
        Objects.requireNonNull(key);
        net.minecraft.world.server.ServerWorld world = this.worlds.get(key);
        if (world != null) {
            return CompletableFuture.completedFuture((ServerWorld)world);
        }
        Path worldDirectory = ((SaveFormatAccessor_Vanilla)this.server.getActiveAnvilConverter()).accessor$getSavesDir().resolve(this.server.getFolderName()).resolve(key.getValue());
        if (Files.notExists(worldDirectory, new LinkOption[0])) {
            return FutureUtil.completedWithException(new IOException(String.format("World '%s' has no directory in '%s'.", key, worldDirectory.getParent().toAbsolutePath())));
        }
        if (Files.notExists(worldDirectory.resolve("level_sponge.dat"), new LinkOption[0])) {
            return FutureUtil.completedWithException(new IOException(String.format("World '%s has no Sponge level data ('%s').", key, "level_sponge.dat")));
        }
        SaveFormat saveFormat = new SaveFormat(worldDirectory.getParent(), worldDirectory.getParent().getParent().resolve("backups"), this.server.getDataFixer());
        SaveHandler saveHandler = saveFormat.getSaveLoader(this.getDirectoryName(key), this.server);
        WorldInfo worldInfo = saveHandler.loadWorldInfo();
        Integer dimensionId = ((WorldInfoBridge)worldInfo).bridge$getDimensionId();
        if (dimensionId == null) {
            return FutureUtil.completedWithException(new IOException(String.format("World '%s' has no dimension id in the Sponge level data ('%s').", key, "level_sponge.dat")));
        }
        ResourceKey existingKey = ((ResourceKeyBridge)worldInfo).bridge$getKey();
        if (existingKey != null && !existingKey.equals(key)) {
            return FutureUtil.completedWithException(new IOException(String.format("World '%s' is keyed as '%s' in the level data.", key, existingKey)));
        }
        ((ResourceKeyBridge)worldInfo).bridge$setKey(key);
        SpongeDimensionType logicType = ((WorldInfoBridge)worldInfo).bridge$getLogicType();
        DimensionType dimensionType = Registry.DIMENSION_TYPE.getValue((ResourceLocation)key).orElseGet(() -> this.createDimensionType(key, logicType, worldDirectory.getFileName().toString(), dimensionId));
        if (dimensionType.getId() + 1 != dimensionId) {
            return FutureUtil.completedWithException(new IOException(String.format("World '%s' specifies internal id '%s' which was already registered.", key, dimensionId)));
        }
        ((DimensionTypeBridge)dimensionType).bridge$setSpongeDimensionType(logicType);
        MinecraftServerAccessor.accessor$getLogger().info("Loading World '{}' ({}/{})", (Object)key, (Object)logicType.getKey().getFormatted(), (Object)dimensionType.getId());
        InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.createWorld(logicType, key);
        ((WorldInfoBridge)worldInfo).bridge$setConfigAdapter(configAdapter);
        IChunkStatusListener chunkStatusListener = ((MinecraftServerAccessor_Vanilla)this.server).accessor$getChunkStatusListenerFactory().create(11);
        world = new net.minecraft.world.server.ServerWorld(this.server, this.server.getBackgroundExecutor(), saveHandler, worldInfo, dimensionType, (IProfiler)this.server.getProfiler(), chunkStatusListener);
        this.loadedWorldInfos.put(key, worldInfo);
        this.infoByType.put(dimensionType, worldInfo);
        this.allInfos.put(key, worldInfo);
        this.worlds.put(key, world);
        this.worldsByType.put(dimensionType, world);
        this.performPostLoadWorldLogic(world, this.createDefaultSettings(null, false, worldInfo.getSeed(), worldInfo.getGenerator(), null), worldDirectory, chunkStatusListener);
        return CompletableFuture.completedFuture((ServerWorld)world);
    }

    @Override
    public CompletableFuture<ServerWorld> loadWorld(WorldProperties properties) {
        DimensionType dimensionType;
        Objects.requireNonNull(properties);
        net.minecraft.world.server.ServerWorld world = this.worlds.get(properties.getKey());
        if (world != null) {
            if (world.getWorldInfo() != properties) {
                return FutureUtil.completedWithException(new IOException(String.format("While '%s' is already a loaded world, the properties does not match the one given", properties.getKey())));
            }
            return CompletableFuture.completedFuture((ServerWorld)world);
        }
        Path worldDirectory = ((SaveFormatAccessor_Vanilla)this.server.getActiveAnvilConverter()).accessor$getSavesDir().resolve(this.server.getFolderName()).resolve(properties.getKey().getValue());
        boolean isOnDisk = Files.exists(worldDirectory, new LinkOption[0]) && Files.exists(worldDirectory.resolve("level.dat"), new LinkOption[0]);
        SaveFormat saveFormat = new SaveFormat(worldDirectory.getParent(), worldDirectory.getParent().getParent().resolve("backups"), this.server.getDataFixer());
        SaveHandler saveHandler = saveFormat.getSaveLoader(this.getDirectoryName(properties.getKey()), this.server);
        if (isOnDisk) {
            properties = (WorldProperties)saveHandler.loadWorldInfo();
        }
        if ((dimensionType = (DimensionType)Registry.DIMENSION_TYPE.getValue((ResourceLocation)properties.getKey()).orElse(null)) != null) {
            if (isOnDisk && !dimensionType.getDirectory(worldDirectory.getParent().toFile()).equals(worldDirectory.toFile())) {
                return FutureUtil.completedWithException(new IOException(String.format("World '%s' was registered with a different directory on this server instance before. Aborting...", properties.getKey())));
            }
            if (((WorldInfoBridge)((Object)properties)).bridge$getDimensionId() != null && dimensionType.getId() + 1 != ((WorldInfoBridge)((Object)properties)).bridge$getDimensionId()) {
                return FutureUtil.completedWithException(new IOException(String.format("World '%s' was registered with a different internal id on this server instance before. Aborting...", properties.getKey())));
            }
        } else {
            int dimensionId;
            if (((WorldInfoBridge)((Object)properties)).bridge$getDimensionId() != null) {
                dimensionType = DimensionType.getById((int)((WorldInfoBridge)((Object)properties)).bridge$getDimensionId());
                if (dimensionType != null) {
                    return FutureUtil.completedWithException(new IOException(String.format("World '%s' is already registered under a different id. Aborting...", properties.getKey())));
                }
                dimensionId = ((WorldInfoBridge)((Object)properties)).bridge$getDimensionId();
            } else {
                dimensionId = ((SimpleRegistryAccessor)Registry.DIMENSION_TYPE).accessor$getNextFreeId();
            }
            dimensionType = this.createDimensionType(properties.getKey(), (SpongeDimensionType)properties.getDimensionType(), worldDirectory.getFileName().toString(), dimensionId);
        }
        ((WorldInfoBridge)((Object)properties)).bridge$setDimensionId(dimensionType);
        WorldInfo worldInfo = (WorldInfo)properties;
        SpongeDimensionType logicType = ((WorldInfoBridge)((Object)properties)).bridge$getLogicType();
        ((DimensionTypeBridge)dimensionType).bridge$setSpongeDimensionType(logicType);
        MinecraftServerAccessor.accessor$getLogger().info("Loading World '{}' ({}/{})", (Object)properties.getKey(), (Object)logicType.getKey().getFormatted(), (Object)dimensionType.getId());
        InheritableConfigHandle<WorldConfig> adapter = SpongeGameConfigs.createWorld(logicType, properties.getKey());
        ((WorldInfoBridge)((Object)properties)).bridge$setConfigAdapter(adapter);
        IChunkStatusListener chunkStatusListener = ((MinecraftServerAccessor_Vanilla)this.server).accessor$getChunkStatusListenerFactory().create(11);
        world = new net.minecraft.world.server.ServerWorld(this.server, this.server.getBackgroundExecutor(), saveHandler, worldInfo, dimensionType, (IProfiler)this.server.getProfiler(), chunkStatusListener);
        this.loadedWorldInfos.put(properties.getKey(), worldInfo);
        this.infoByType.put(dimensionType, worldInfo);
        this.allInfos.put(properties.getKey(), worldInfo);
        this.worlds.put(properties.getKey(), world);
        this.worldsByType.put(dimensionType, world);
        this.performPostLoadWorldLogic(world, this.createDefaultSettings(null, false, worldInfo.getSeed(), worldInfo.getGenerator(), null), worldDirectory, chunkStatusListener);
        return CompletableFuture.completedFuture((ServerWorld)world);
    }

    @Override
    public CompletableFuture<Boolean> unloadWorld(ResourceKey key) {
        Objects.requireNonNull(key);
        if (key.equals(VANILLA_OVERWORLD)) {
            return FutureUtil.completedWithException(new IOException("The default world can not be unloaded"));
        }
        net.minecraft.world.server.ServerWorld world = this.worlds.get(key);
        if (world == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.unloadWorld((ServerWorld)world);
    }

    @Override
    public CompletableFuture<Boolean> unloadWorld(ServerWorld world) {
        Objects.requireNonNull(world);
        if (world.getKey().equals(VANILLA_OVERWORLD)) {
            return FutureUtil.completedWithException(new IOException("The default world can not be unloaded."));
        }
        if (world != this.worlds.get(world.getKey())) {
            return FutureUtil.completedWithException(new IOException(String.format("World '%s' was told to unload but does not match the actual world loaded.", world.getKey())));
        }
        if (world.getPlayers().size() != 0) {
            return FutureUtil.completedWithException(new IOException(String.format("World '%s' was told to unload but players remain.", world.getKey())));
        }
        net.minecraft.world.server.ServerWorld mWorld = (net.minecraft.world.server.ServerWorld)world;
        SpongeCommon.getLogger().info("Unloading World '{}' ({}/{})", (Object)world.getKey(), (Object)world.getDimensionType().getKey(), (Object)mWorld.dimension.getType().getId());
        mWorld.getChunkProvider().releaseTicket(SPAWN_CHUNKS, new ChunkPos(world.getProperties().getSpawnPosition().getX(), world.getProperties().getSpawnPosition().getZ()), 11, (Object)((ResourceLocation)world.getKey()));
        ((WorldInfoBridge)mWorld.getWorldInfo()).bridge$getConfigAdapter().save();
        ((ServerWorldBridge)((Object)world)).bridge$setManualSave(true);
        try {
            mWorld.save(null, true, mWorld.disableLevelSaving);
            mWorld.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.loadedWorldInfos.remove(world.getKey());
        this.infoByType.remove(mWorld.dimension.getType());
        this.worlds.remove(world.getKey());
        this.worldsByType.remove(mWorld.dimension.getType());
        SpongeCommon.postEvent(SpongeEventFactory.createUnloadWorldEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), world));
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public Optional<WorldProperties> getProperties(ResourceKey key) {
        Objects.requireNonNull(key);
        return Optional.ofNullable(this.allInfos.get(key));
    }

    @Override
    public Collection<WorldProperties> getUnloadedProperties() {
        ArrayList<WorldProperties> unloadedProperties = new ArrayList<WorldProperties>();
        for (WorldInfo worldInfo : this.allInfos.values()) {
            boolean unloaded = true;
            for (net.minecraft.world.server.ServerWorld value : this.worlds.values()) {
                if (value.getWorldInfo() != worldInfo) continue;
                unloaded = false;
                break;
            }
            if (!unloaded) continue;
            unloadedProperties.add((WorldProperties)worldInfo);
        }
        return unloadedProperties;
    }

    @Override
    public Collection<WorldProperties> getAllProperties() {
        return Collections.unmodifiableCollection(this.allInfos.values());
    }

    @Override
    public CompletableFuture<Boolean> saveProperties(WorldProperties properties) {
        Objects.requireNonNull(properties);
        Path worldDirectory = ((SaveFormatAccessor_Vanilla)this.server.getActiveAnvilConverter()).accessor$getSavesDir().resolve(this.server.getFolderName()).resolve(properties.getKey().getValue());
        SaveFormat saveFormat = new SaveFormat(worldDirectory.getParent(), worldDirectory.getParent().getParent().resolve("backups"), this.server.getDataFixer());
        SaveHandler saveHandler = saveFormat.getSaveLoader(this.getDirectoryName(properties.getKey()), this.server);
        saveHandler.saveWorldInfo((WorldInfo)properties);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<WorldProperties> copyWorld(ResourceKey key, String copyValue) {
        return null;
    }

    @Override
    public CompletableFuture<WorldProperties> renameWorld(ResourceKey key, String newValue) {
        return null;
    }

    @Override
    public CompletableFuture<Boolean> deleteWorld(ResourceKey key) {
        return null;
    }

    @Override
    public boolean registerPendingWorld(ResourceKey key, @Nullable WorldArchetype archetype) {
        Objects.requireNonNull(key);
        if (this.pendingWorlds.containsKey(key)) {
            return false;
        }
        this.pendingWorlds.put(key, new WorldRegistration(key, null, (WorldSettings)archetype));
        return true;
    }

    @Override
    public @Nullable net.minecraft.world.server.ServerWorld getWorld(DimensionType dimensionType) {
        Objects.requireNonNull(dimensionType);
        return this.worldsByType.get(dimensionType);
    }

    @Override
    public @Nullable net.minecraft.world.server.ServerWorld getWorld0(ResourceKey key) {
        if (key == null) {
            return null;
        }
        return this.worlds.get(key);
    }

    @Override
    public @Nullable net.minecraft.world.server.ServerWorld getDefaultWorld() {
        return this.worlds.get(VANILLA_OVERWORLD);
    }

    @Override
    public void adjustWorldForDifficulty(net.minecraft.world.server.ServerWorld world, Difficulty newDifficulty, boolean forceDifficulty) {
        if (world.getWorldInfo().isDifficultyLocked() && !forceDifficulty) {
            return;
        }
        if (forceDifficulty) {
            if (!((WorldInfoBridge)world.getWorldInfo()).bridge$hasCustomDifficulty()) {
                ((WorldInfoBridge)world.getWorldInfo()).bridge$forceSetDifficulty(newDifficulty);
            }
        } else {
            world.getWorldInfo().setDifficulty(newDifficulty);
        }
    }

    @Override
    public void loadAllWorlds(String saveName, String levelName, long seed, WorldType type, JsonElement generatorOptions, boolean isSinglePlayer, @Nullable WorldSettings defaultSettings, Difficulty defaultDifficulty) {
        ((MinecraftServerAccessor_Vanilla)this.server).accessor$convertMapIfNeeded(saveName);
        SpongeCommon.postEvent(new RegisterWorldEventImpl(PhaseTracker.getCauseStackManager().getCurrentCause(), SpongeCommon.getGame(), this));
        try {
            this.loadExistingWorldRegistrations();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception caught registering existing Sponge worlds!", e);
        }
        Path savesDirectory = ((SaveFormatAccessor_Vanilla)this.server.getActiveAnvilConverter()).accessor$getSavesDir();
        Path worldsDirectory = savesDirectory.resolve(saveName);
        if (!isSinglePlayer) {
            try {
                if (Files.isSymbolicLink(worldsDirectory)) {
                    Path actualPathLink = Files.readSymbolicLink(worldsDirectory);
                    if (Files.notExists(actualPathLink, new LinkOption[0])) {
                        Files.createDirectories(actualPathLink, new FileAttribute[0]);
                    } else if (!Files.isDirectory(actualPathLink, new LinkOption[0])) {
                        throw new IOException(String.format("Worlds directory '%s' symlink to '%s' is not a directory!", worldsDirectory, actualPathLink));
                    }
                } else {
                    Files.createDirectories(worldsDirectory, new FileAttribute[0]);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Exception caught when reading symlinks for world containers!", ex);
            }
            if (!this.server.getAllowNether()) {
                SpongeCommon.getLogger().warn("The option 'allow-nether' has been set to 'false' in the server.properties. Multi-World support has been disabled and no worlds besides the default world will be loaded.");
            }
        }
        ((MinecraftServerAccessor_Vanilla)this.server).accessor$setUserMessage((ITextComponent)new TranslationTextComponent("menu.loadingLevel", new Object[0]));
        for (Map.Entry<ResourceKey, WorldRegistration> entry : this.pendingWorlds.entrySet()) {
            SaveHandler saveHandler;
            SaveFormat saveFormat;
            ResourceKey key = entry.getKey();
            WorldRegistration worldRegistration = entry.getValue();
            boolean isDefaultWorld = VANILLA_OVERWORLD.equals(key);
            if (!isDefaultWorld && !isSinglePlayer && !this.server.getAllowNether()) continue;
            Path worldDirectory = isDefaultWorld ? worldsDirectory : worldsDirectory.resolve(this.getDirectoryName(key));
            DimensionType dimensionType = Registry.DIMENSION_TYPE.getValue((ResourceLocation)key).orElse(null);
            if (dimensionType == null) {
                dimensionType = this.createDimensionType(worldRegistration.getKey(), (SpongeDimensionType)((WorldArchetype)worldRegistration.getDefaultSettings()).getDimensionType(), worldDirectory.getFileName().toString(), ((SimpleRegistryAccessor)Registry.DIMENSION_TYPE).accessor$getNextFreeId());
            }
            SpongeDimensionType logicType = ((DimensionTypeBridge)dimensionType).bridge$getSpongeDimensionType();
            MinecraftServerAccessor.accessor$getLogger().info("Loading World '{}' ({}/{})", (Object)key, (Object)logicType.getKey().getFormatted(), (Object)dimensionType.getId());
            boolean configExists = SpongeGameConfigs.doesWorldConfigExist(key);
            InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.createWorld(logicType, key);
            if (!isDefaultWorld && !((WorldConfig)configAdapter.get()).getWorld().isWorldEnabled()) {
                SpongeCommon.getLogger().warn("World '{}' ({}/{}) has been disabled in the configuration. World will not be loaded...", (Object)key, (Object)logicType.getKey().getFormatted(), (Object)dimensionType.getId());
                continue;
            }
            if (isDefaultWorld) {
                saveFormat = this.server.getActiveAnvilConverter();
                saveHandler = saveFormat.getSaveLoader(saveName, this.server);
            } else {
                saveFormat = new SaveFormat(worldDirectory.getParent(), worldDirectory.getParent().getParent().resolve("backups"), this.server.getDataFixer());
                saveHandler = saveFormat.getSaveLoader(this.getDirectoryName(key), this.server);
            }
            WorldInfo worldInfo = saveHandler.loadWorldInfo();
            if (worldInfo == null) {
                if (worldRegistration.getDefaultSettings() != null) {
                    defaultSettings = worldRegistration.getDefaultSettings();
                }
                if (isSinglePlayer) {
                    ((WorldSettingsBridge)defaultSettings).bridge$setInfoConfigAdapter(configAdapter);
                    ((WorldSettingsBridge)defaultSettings).bridge$setConfigExists(configExists);
                    worldInfo = new WorldInfo(defaultSettings, isDefaultWorld ? levelName : this.getDirectoryName(key));
                } else {
                    if (defaultSettings == null) {
                        defaultSettings = this.createDefaultSettings(defaultSettings, isDefaultWorld, seed, type, generatorOptions);
                    }
                    ((WorldSettingsBridge)defaultSettings).bridge$setInfoConfigAdapter(configAdapter);
                    ((WorldSettingsBridge)defaultSettings).bridge$setConfigExists(configExists);
                    worldInfo = new WorldInfo(defaultSettings, isDefaultWorld ? levelName : this.getDirectoryName(key));
                }
                ((ResourceKeyBridge)worldInfo).bridge$setKey(worldRegistration.getKey());
                ((WorldInfoBridge)worldInfo).bridge$setConfigAdapter(configAdapter);
                ((WorldInfoBridge)worldInfo).bridge$setDimensionId(dimensionType);
                ((WorldInfoBridge)worldInfo).bridge$setUniqueId(UUID.randomUUID());
                SpongeCommon.postEvent(SpongeEventFactory.createConstructWorldPropertiesEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (WorldArchetype)defaultSettings, (WorldProperties)worldInfo));
            } else {
                ((WorldInfoBridge)worldInfo).bridge$setConfigAdapter(configAdapter);
                worldInfo.setWorldName(isDefaultWorld ? saveName : this.getDirectoryName(key));
                if (((ResourceKeyBridge)worldInfo).bridge$getKey() == null) {
                    ((ResourceKeyBridge)worldInfo).bridge$setKey(worldRegistration.getKey());
                    ((WorldInfoBridge)worldInfo).bridge$setDimensionId(dimensionType);
                    ((WorldInfoBridge)worldInfo).bridge$setUniqueId(UUID.randomUUID());
                }
                defaultSettings = new WorldSettings(worldInfo);
            }
            if (((WorldInfoBridge)worldInfo).bridge$getLogicType() != null) {
                ((DimensionTypeBridge)dimensionType).bridge$setSpongeDimensionType(((WorldInfoBridge)worldInfo).bridge$getLogicType());
            } else {
                ((WorldInfoBridge)worldInfo).bridge$setLogicType(((DimensionTypeBridge)dimensionType).bridge$getSpongeDimensionType(), false);
            }
            if (isDefaultWorld) {
                ((MinecraftServerAccessor_Vanilla)this.server).accessor$loadDataPacks(worldDirectory.toFile(), worldInfo);
            }
            this.loadedWorldInfos.put(key, worldInfo);
            this.infoByType.put(dimensionType, worldInfo);
            this.allInfos.put(key, worldInfo);
            if (!isDefaultWorld && !((WorldProperties)worldInfo).doesLoadOnStartup()) {
                SpongeCommon.getLogger().warn("World '{}' ({}/{}) has been set to not load on startup in the configuration. Skipping...", (Object)key, (Object)logicType.getKey().getFormatted(), (Object)dimensionType.getId());
                continue;
            }
            IChunkStatusListener chunkStatusListener = ((MinecraftServerAccessor_Vanilla)this.server).accessor$getChunkStatusListenerFactory().create(11);
            worldInfo.func_230145_a_(this.server.getServerModName(), this.server.func_230045_q_().isPresent());
            net.minecraft.world.server.ServerWorld serverWorld = new net.minecraft.world.server.ServerWorld(this.server, this.server.getBackgroundExecutor(), saveHandler, worldInfo, dimensionType, (IProfiler)this.server.getProfiler(), chunkStatusListener);
            this.worlds.put(key, serverWorld);
            this.worldsByType.put(dimensionType, serverWorld);
            this.performPostLoadWorldLogic(serverWorld, defaultSettings, worldDirectory, chunkStatusListener);
        }
        this.pendingWorlds.clear();
        if (this.server.isSinglePlayer()) {
            this.server.setDifficultyForAllWorlds(defaultDifficulty, true);
        } else {
            this.server.setDifficultyForAllWorlds(this.server.getDifficulty(), true);
        }
        ((SpongeServer)SpongeCommon.getServer()).getPlayerDataManager().load();
    }

    private void clearCustomWorldDimensions() {
        ArrayList<DimensionType> customDimensions = new ArrayList<DimensionType>();
        for (DimensionType next : Registry.DIMENSION_TYPE) {
            if (next.getId() + 1 <= 2) continue;
            customDimensions.add(next);
        }
        ((SimpleRegistryBridge)Registry.DIMENSION_TYPE).bridge$removeAll(customDimensions);
    }

    private void loadSpawnChunks(net.minecraft.world.server.ServerWorld serverWorld, IChunkStatusListener chunkStatusListener) {
        ((MinecraftServerAccessor_Vanilla)this.server).accessor$setUserMessage((ITextComponent)new TranslationTextComponent("menu.generatingTerrain", new Object[0]));
        ServerWorld apiWorld = (ServerWorld)serverWorld;
        MinecraftServerAccessor.accessor$getLogger().info("Preparing start region for world '{}' ({}/{})", (Object)apiWorld.getKey(), (Object)apiWorld.getProperties().getDimensionType().getKey(), (Object)serverWorld.getDimension().getType().getId());
        BlockPos spawnPoint = serverWorld.getSpawnPoint();
        ChunkPos spawnChunkPos = new ChunkPos(spawnPoint);
        chunkStatusListener.start(spawnChunkPos);
        ServerChunkProvider chunkProvider = serverWorld.getChunkProvider();
        chunkProvider.getLightManager().func_215598_a(500);
        ((MinecraftServerAccessor_Vanilla)this.server).accessor$setServerTime(Util.milliTime());
        chunkProvider.registerTicket(SPAWN_CHUNKS, spawnChunkPos, 11, (Object)((ResourceLocation)apiWorld.getKey()));
        while (chunkProvider.getLoadedChunksCount() != 441) {
            ((MinecraftServerAccessor_Vanilla)this.server).accessor$setServerTime(Util.milliTime() + 10L);
            ((MinecraftServerAccessor_Vanilla)this.server).accessor$runScheduledTasks();
        }
        ((MinecraftServerAccessor_Vanilla)this.server).accessor$setServerTime(Util.milliTime() + 10L);
        ((MinecraftServerAccessor_Vanilla)this.server).accessor$runScheduledTasks();
        ForcedChunksSaveData forcedChunksSaveData = (ForcedChunksSaveData)serverWorld.getSavedData().get(ForcedChunksSaveData::new, "chunks");
        if (forcedChunksSaveData != null) {
            LongIterator longIterator = forcedChunksSaveData.getChunks().iterator();
            while (longIterator.hasNext()) {
                long i = longIterator.nextLong();
                ChunkPos chunkpos = new ChunkPos(i);
                serverWorld.getChunkProvider().forceChunk(chunkpos, true);
            }
        }
        ((MinecraftServerAccessor_Vanilla)this.server).accessor$setServerTime(Util.milliTime() + 10L);
        ((MinecraftServerAccessor_Vanilla)this.server).accessor$runScheduledTasks();
        chunkStatusListener.stop();
        chunkProvider.getLightManager().func_215598_a(5);
        if (!((WorldInfoBridge)serverWorld.getWorldInfo()).bridge$doesKeepSpawnLoaded()) {
            chunkProvider.releaseTicket(SPAWN_CHUNKS, spawnChunkPos, 11, (Object)((ResourceLocation)apiWorld.getKey()));
        }
    }

    private DimensionType createDimensionType(ResourceKey key, SpongeDimensionType logicType, String worldDirectory, int dimensionId) {
        DimensionType registeredType = DimensionTypeAccessor.accessor$construct(dimensionId, "", worldDirectory, logicType.getDimensionFactory(), logicType.hasSkylight(), (IBiomeMagnifier)(logicType == DimensionTypes.OVERWORLD.get() ? ColumnFuzzedBiomeMagnifier.INSTANCE : FuzzedBiomeMagnifier.INSTANCE));
        DimensionTypeAccessor.accessor$register(key.getFormatted(), registeredType);
        ((DimensionTypeBridge)registeredType).bridge$setSpongeDimensionType(logicType);
        return registeredType;
    }

    private void loadExistingWorldRegistrations() throws IOException {
        if (Files.notExists(this.savesDirectory, new LinkOption[0])) {
            return;
        }
        for (Path path2 : Files.walk(this.savesDirectory, 1, new FileVisitOption[0]).filter(path -> !this.savesDirectory.equals(path) && Files.isDirectory(path, new LinkOption[0]) && !this.isVanillaSubLevel(path.getFileName().toString()) && Files.exists(path.resolve("level_sponge.dat"), new LinkOption[0])).collect(Collectors.toList())) {
            ResourceKey key;
            String worldDirectory = path2.getFileName().toString();
            CompoundNBT worldCompound = CompressedStreamTools.readCompressed((InputStream)new FileInputStream(path2.resolve("level_sponge.dat").toFile()));
            CompoundNBT spongeDataCompound = worldCompound.getCompound("SpongeData");
            String rawKey = spongeDataCompound.getString("Key");
            if (rawKey.isEmpty()) {
                key = ResourceKey.sponge(worldDirectory.toLowerCase());
                SpongeCommon.getLogger().warn("World '{}' was created on an older Sponge version (before Minecraft 1.15) which had no concept of which plugin created it. To compensate, this world will be created with the key '{}'. Please specify this key to any plugins that need to know of this world.", (Object)worldDirectory, (Object)key);
            } else {
                key = ResourceKey.resolve(rawKey);
            }
            int dimensionId = spongeDataCompound.getInt("dimensionId");
            DimensionType registeredType = (DimensionType)Registry.DIMENSION_TYPE.getByValue(dimensionId);
            if (registeredType != null) {
                SpongeCommon.getLogger().error("Duplicate id '{}' is being loaded by '{}' but was previously loaded by '{}'. Skipping...", (Object)dimensionId, (Object)worldDirectory, (Object)DimensionType.getKey((DimensionType)registeredType).getPath());
                continue;
            }
            String rawLogicType = spongeDataCompound.getString("dimensionType");
            SpongeDimensionType logicType = SpongeCommon.getRegistry().getCatalogRegistry().get(org.spongepowered.api.world.dimension.DimensionType.class, ResourceKey.resolve(rawLogicType)).orElse(null);
            if (logicType == null) {
                SpongeCommon.getLogger().warn("World '{}' has an unknown dimension type '{}'. Falling back to '{}'.", (Object)worldDirectory, (Object)rawLogicType, (Object)DimensionTypes.OVERWORLD.get().getKey());
                logicType = (SpongeDimensionType)DimensionTypes.OVERWORLD.get();
            }
            registeredType = this.createDimensionType(key, logicType, worldDirectory, dimensionId);
            WorldRegistration existingRegistration = this.pendingWorlds.get(key);
            if (existingRegistration != null) {
                existingRegistration.setDimensionType(registeredType);
                continue;
            }
            this.pendingWorlds.put(key, new WorldRegistration(key, registeredType, null));
        }
    }

    private boolean isVanillaSubLevel(String directoryName) {
        return "DIM-1".equals(directoryName) || "DIM1".equals(directoryName);
    }

    private WorldSettings createDefaultSettings(@Nullable WorldSettings providedSettings, boolean isDefaultWorld, long seed, WorldType worldType, @Nullable JsonElement generatorOptions) {
        if (providedSettings == null) {
            if (this.server.isDemo()) {
                providedSettings = MinecraftServer.DEMO_WORLD_SETTINGS;
            } else {
                providedSettings = new WorldSettings(seed, this.server.getGameType(), this.server.canStructuresSpawn(), this.server.isHardcore(), worldType);
                if (isDefaultWorld) {
                    providedSettings.setGeneratorOptions(generatorOptions);
                    if (((MinecraftServerAccessor_Vanilla)this.server).accessor$getEnableBonusChest()) {
                        providedSettings.enableBonusChest();
                    }
                }
            }
        }
        return providedSettings;
    }

    private void performPostLoadWorldLogic(net.minecraft.world.server.ServerWorld serverWorld, WorldSettings defaultSettings, Path worldDirectory, IChunkStatusListener listener) {
        boolean generateSpawnOnLoad;
        boolean isDefaultWorld;
        boolean bl = isDefaultWorld = serverWorld.getDimension().getType() == DimensionType.OVERWORLD;
        if (serverWorld.getWorldInfo().getGameType() == GameType.NOT_SET) {
            serverWorld.getWorldInfo().setGameType(this.server.getGameType());
        }
        if (isDefaultWorld) {
            ((MinecraftServerAccessor_Vanilla)this.server).accessor$func_213204_a(serverWorld.getSavedData());
            ((MinecraftServerAccessor)this.server).accessor$setfield_229733_al(new CommandStorage(serverWorld.getSavedData()));
        }
        serverWorld.getWorldBorder().copyFrom(serverWorld.getWorldInfo());
        if (!serverWorld.getWorldInfo().isInitialized()) {
            try {
                serverWorld.createSpawnPosition(defaultSettings);
                if (serverWorld.getWorldInfo().getGenerator() == WorldType.DEBUG_ALL_BLOCK_STATES) {
                    ((MinecraftServerAccessor_Vanilla)this.server).accessor$applyDebugWorldInfo(serverWorld.getWorldInfo());
                }
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.makeCrashReport((Throwable)throwable, (String)("Exception initializing world '" + worldDirectory + "'"));
                try {
                    serverWorld.fillCrashReport(crashReport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            finally {
                serverWorld.getWorldInfo().setInitialized(true);
            }
        }
        this.server.getPlayerList().func_212504_a(serverWorld);
        if (isDefaultWorld) {
            ((SpongeUserManager)((Server)this.server).getUserManager()).init();
        }
        if (serverWorld.getWorldInfo().getCustomBossEvents() != null) {
            ((ServerWorldBridge)serverWorld).bridge$getBossBarManager().read(serverWorld.getWorldInfo().getCustomBossEvents());
        }
        ServerWorld apiWorld = (ServerWorld)serverWorld;
        SpongeCommon.postEvent(SpongeEventFactory.createLoadWorldEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), apiWorld));
        boolean bl2 = generateSpawnOnLoad = ((WorldInfoBridge)serverWorld.getWorldInfo()).bridge$doesGenerateSpawnOnLoad() || isDefaultWorld;
        if (generateSpawnOnLoad) {
            this.loadSpawnChunks(serverWorld, listener);
        } else {
            serverWorld.getChunkProvider().registerTicket(SPAWN_CHUNKS, new ChunkPos(apiWorld.getProperties().getSpawnPosition().getX(), apiWorld.getProperties().getSpawnPosition().getZ()), 11, (Object)((ResourceLocation)apiWorld.getKey()));
        }
    }
}

