/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.selector;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.selector.SelectorSortAlgorithm;
import org.spongepowered.api.command.selector.SelectorType;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.math.vector.Vector3d;

public interface Selector {
    public static Selector parse(String string) throws IllegalArgumentException {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).parse(string);
    }

    public static Builder builder() {
        return Sponge.getGame().getBuilderProvider().provide(Builder.class);
    }

    public Collection<Entity> select(ServerLocation var1) throws IllegalStateException;

    public Collection<Entity> select(Entity var1) throws IllegalStateException;

    public Collection<Entity> select(CommandCause var1);

    public static interface Factory {
        public Selector parse(String var1) throws IllegalArgumentException;
    }

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Selector, Builder> {
        public Builder applySelectorType(Supplier<? extends SelectorType> var1);

        public Builder applySelectorType(SelectorType var1);

        public Builder includeSelf();

        public Builder setLimit(int var1);

        public Builder setDistance(Range<Double> var1);

        public Builder setVolume(Vector3d var1, Vector3d var2);

        public Builder setSortAlgorithm(Supplier<? extends SelectorSortAlgorithm> var1);

        public Builder setSortAlgorithm(SelectorSortAlgorithm var1);

        public Builder advancement(Advancement var1);

        public Builder notAdvancement(Advancement var1);

        public Builder advancementCriterion(Advancement var1, AdvancementCriterion var2);

        public Builder notAdvancementCriterion(Advancement var1, AdvancementCriterion var2);

        public Builder setDataView(DataView var1);

        public Builder entityType(Supplier<EntityType<?>> var1, boolean var2);

        public Builder entityType(EntityType<?> var1, boolean var2);

        public Builder notEntityType(Supplier<EntityType<?>> var1);

        public Builder notEntityType(EntityType<?> var1);

        public Builder setExperienceLevel(Range<Integer> var1);

        public Builder gameMode(Supplier<? extends GameMode> var1);

        public Builder gameMode(GameMode var1);

        public Builder notGameMode(Supplier<? extends GameMode> var1);

        public Builder notGameMode(GameMode var1);

        public Builder anyTeam();

        public Builder noTeam();

        public Builder team(Team var1);

        public Builder notTeam(Team var1);

        public Builder name(String var1);

        public Builder notName(String var1);

        public Builder score(Score var1, Range<Integer> var2);

        public Builder tag(String var1);

        public Builder notTag(String var1);

        public Builder setPitch(Range<Double> var1);

        public Builder setYaw(Range<Double> var1);

        public Builder filter(Predicate<Entity> var1);

        public Selector build() throws IllegalStateException;
    }
}

