/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.util.annotation.DoNotStore;

@DoNotStore
public interface DataHolder
extends ValueContainer {

    public static interface Immutable<I extends Immutable<I>>
    extends DataHolder {
        public <E> Optional<I> transform(Key<? extends Value<E>> var1, Function<E, E> var2);

        default public <E> Optional<I> transform(Supplier<? extends Key<? extends Value<E>>> key, Function<E, E> function) {
            return this.transform(key.get(), function);
        }

        public <E> Optional<I> with(Key<? extends Value<E>> var1, E var2);

        default public <E> Optional<I> with(Supplier<? extends Key<? extends Value<E>>> key, E value) {
            return this.with(key.get(), value);
        }

        public Optional<I> with(Value<?> var1);

        default public Optional<I> without(Value<?> value) {
            return this.without(value.getKey());
        }

        public Optional<I> without(Key<?> var1);

        default public Optional<I> without(Supplier<? extends Key<?>> key) {
            return this.without(key.get());
        }

        default public I mergeWith(I that) {
            return this.mergeWith(that, MergeFunction.REPLACEMENT_PREFERRED);
        }

        public I mergeWith(I var1, MergeFunction var2);
    }

    public static interface Mutable
    extends DataHolder {
        default public <E> DataTransactionResult transform(Key<? extends Value<E>> key, Function<E, E> function) {
            if (this.supports(key)) {
                return this.get(key).map(function).map(value -> this.offer(key, value)).orElseGet(DataTransactionResult::failNoData);
            }
            return DataTransactionResult.failNoData();
        }

        default public <E> DataTransactionResult transform(Supplier<? extends Key<? extends Value<E>>> key, Function<E, E> function) {
            return this.transform(key.get(), function);
        }

        public <E> DataTransactionResult offer(Key<? extends Value<E>> var1, E var2);

        default public <E> DataTransactionResult offer(Supplier<? extends Key<? extends Value<E>>> key, E value) {
            return this.offer(key.get(), value);
        }

        default public <E> DataTransactionResult offer(Supplier<? extends Key<? extends Value<E>>> key, Supplier<? extends E> value) {
            return this.offer(key.get(), value.get());
        }

        public DataTransactionResult offer(Value<?> var1);

        public <E> DataTransactionResult offerSingle(Key<? extends CollectionValue<E, ?>> var1, E var2);

        default public <E> DataTransactionResult offerSingle(Supplier<? extends Key<? extends CollectionValue<E, ?>>> key, E element) {
            return this.offerSingle(key.get(), element);
        }

        public <K, V> DataTransactionResult offerSingle(Key<? extends MapValue<K, V>> var1, K var2, V var3);

        default public <K, V> DataTransactionResult offerSingle(Supplier<? extends Key<? extends MapValue<K, V>>> key, K valueKey, V value) {
            return this.offerSingle(key.get(), valueKey, value);
        }

        public <K, V> DataTransactionResult offerAll(Key<? extends MapValue<K, V>> var1, Map<? extends K, ? extends V> var2);

        default public <K, V> DataTransactionResult offerAll(Supplier<? extends Key<? extends MapValue<K, V>>> key, Map<? extends K, ? extends V> map) {
            return this.offerAll(key.get(), map);
        }

        public DataTransactionResult offerAll(MapValue<?, ?> var1);

        public DataTransactionResult offerAll(CollectionValue<?, ?> var1);

        public <E> DataTransactionResult offerAll(Key<? extends CollectionValue<E, ?>> var1, Collection<? extends E> var2);

        default public <E> DataTransactionResult offerAll(Supplier<? extends Key<? extends CollectionValue<E, ?>>> key, Collection<? extends E> elements) {
            return this.offerAll(key.get(), elements);
        }

        public <E> DataTransactionResult removeSingle(Key<? extends CollectionValue<E, ?>> var1, E var2);

        default public <E> DataTransactionResult removeSingle(Supplier<? extends Key<? extends CollectionValue<E, ?>>> key, E element) {
            return this.removeSingle(key.get(), element);
        }

        public <K> DataTransactionResult removeKey(Key<? extends MapValue<K, ?>> var1, K var2);

        default public <K> DataTransactionResult removeKey(Supplier<? extends Key<? extends MapValue<K, ?>>> key, K mapKey) {
            return this.removeKey(key.get(), mapKey);
        }

        public DataTransactionResult removeAll(CollectionValue<?, ?> var1);

        public <E> DataTransactionResult removeAll(Key<? extends CollectionValue<E, ?>> var1, Collection<? extends E> var2);

        default public <E> DataTransactionResult removeAll(Supplier<? extends Key<? extends CollectionValue<E, ?>>> key, Collection<? extends E> elements) {
            return this.removeAll(key.get(), elements);
        }

        public DataTransactionResult removeAll(MapValue<?, ?> var1);

        public <K, V> DataTransactionResult removeAll(Key<? extends MapValue<K, V>> var1, Map<? extends K, ? extends V> var2);

        default public <K, V> DataTransactionResult removeAll(Supplier<? extends Key<? extends MapValue<K, V>>> key, Map<? extends K, ? extends V> map) {
            return this.removeAll(key.get(), map);
        }

        public <E> DataTransactionResult tryOffer(Key<? extends Value<E>> var1, E var2);

        default public <E> DataTransactionResult tryOffer(Supplier<? extends Key<? extends Value<E>>> key, E value) {
            return this.tryOffer(key.get(), value);
        }

        default public <E> DataTransactionResult tryOffer(Value<E> value) throws IllegalArgumentException {
            DataTransactionResult result = this.offer(value.getKey(), value.get());
            if (!result.isSuccessful()) {
                throw new IllegalArgumentException("Failed offer transaction!");
            }
            return result;
        }

        default public DataTransactionResult remove(Value<?> value) {
            return this.remove(value.getKey());
        }

        public DataTransactionResult remove(Key<?> var1);

        default public DataTransactionResult remove(Supplier<? extends Key<?>> key) {
            return this.remove(key.get());
        }

        public DataTransactionResult undo(DataTransactionResult var1);

        default public DataTransactionResult copyFrom(ValueContainer that) {
            return this.copyFrom(that, MergeFunction.REPLACEMENT_PREFERRED);
        }

        public DataTransactionResult copyFrom(ValueContainer var1, MergeFunction var2);
    }
}

