/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import org.spongepowered.api.Sponge;
import org.spongepowered.math.imaginary.Quaterniond;
import org.spongepowered.math.matrix.Matrix4d;
import org.spongepowered.math.vector.Vector3d;

public interface Transform {
    public static Transform of(Vector3d position) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).create(position, Vector3d.ZERO, Vector3d.ONE);
    }

    public static Transform of(Vector3d position, Vector3d rotation) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).create(position, rotation, Vector3d.ONE);
    }

    public static Transform of(Vector3d position, Vector3d rotation, Vector3d scale) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).create(position, rotation, scale);
    }

    public Vector3d getPosition();

    public Transform withPosition(Vector3d var1);

    public Vector3d getRotation();

    public Transform withRotation(Vector3d var1);

    public Transform withRotation(Quaterniond var1);

    public Quaterniond getRotationAsQuaternion();

    public double getPitch();

    public double getYaw();

    public double getRoll();

    public Vector3d getScale();

    public Transform withScale(Vector3d var1);

    public Transform add(Transform var1);

    public Transform translate(Vector3d var1);

    public Transform rotate(Vector3d var1);

    public Transform rotate(Quaterniond var1);

    public Transform scale(Vector3d var1);

    public Matrix4d toMatrix();

    public static interface Factory {
        public Transform create(Vector3d var1, Vector3d var2, Vector3d var3);
    }
}

