/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.schematic;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.world.schematic.PaletteReference;
import org.spongepowered.api.world.schematic.PaletteType;

public interface Palette<T, R> {
    public PaletteType<T, R> getType();

    public int getHighestId();

    public Optional<PaletteReference<T, R>> get(int var1);

    default public Optional<T> get(int id, RegistryHolder holder) {
        return this.get(id).flatMap(ref -> Objects.requireNonNull(holder, "RegistryHolder cannot be null").findRegistry(ref.registry()).flatMap(reg -> this.getType().getResolver().apply(ref.value(), (Registry<R>)reg)));
    }

    public OptionalInt get(T var1);

    public Stream<T> stream();

    public Stream<Map.Entry<T, Integer>> streamWithIds();

    public Mutable<T, R> asMutable(RegistryHolder var1);

    public Immutable<T, R> asImmutable();

    public static interface Immutable<I, IR>
    extends Palette<I, IR> {
        @Override
        default public Immutable<I, IR> asImmutable() {
            return this;
        }
    }

    public static interface Mutable<M, MR>
    extends Palette<M, MR> {
        public int getOrAssign(M var1);

        public boolean remove(M var1);

        @Override
        default public Mutable<M, MR> asMutable(RegistryHolder registry) {
            return this;
        }
    }
}

