/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.server;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.raid.Raid;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.ChunkRegenerateFlag;
import org.spongepowered.api.world.ChunkRegenerateFlags;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerLocationCreator;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.storage.WorldStorage;
import org.spongepowered.api.world.volume.game.InteractableVolume;
import org.spongepowered.api.world.weather.WeatherUniverse;
import org.spongepowered.math.vector.Vector3i;

public interface ServerWorld
extends World<ServerWorld, ServerLocation>,
Identifiable,
InteractableVolume,
ServerLocationCreator,
WeatherUniverse.Mutable {
    @Override
    public Server getEngine();

    @Override
    public ServerWorldProperties getProperties();

    public ChunkGenerator getGenerator();

    public WorldTemplate asTemplate();

    public ResourceKey getKey();

    @Override
    default public UUID getUniqueId() {
        return this.getProperties().getUniqueId();
    }

    @Override
    default public Chunk getChunkAtBlock(int bx, int by, int bz) {
        Vector3i chunkPos = this.getEngine().getChunkLayout().forceToChunk(bx, by, bz);
        return this.getChunk(chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    default public Optional<Chunk> regenerateChunk(Vector3i chunkPosition) {
        Objects.requireNonNull(chunkPosition, "chunkPosition");
        return this.regenerateChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ(), ChunkRegenerateFlags.ALL.get());
    }

    default public Optional<Chunk> regenerateChunk(int cx, int cy, int cz) {
        return this.regenerateChunk(cx, cy, cz, ChunkRegenerateFlags.ALL.get());
    }

    default public Optional<Chunk> regenerateChunk(Vector3i chunkPosition, ChunkRegenerateFlag flag) {
        Objects.requireNonNull(chunkPosition, "chunkPosition");
        return this.regenerateChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ(), Objects.requireNonNull(flag, "flag"));
    }

    public Optional<Chunk> regenerateChunk(int var1, int var2, int var3, ChunkRegenerateFlag var4);

    default public BlockSnapshot createSnapshot(Vector3i position) {
        Objects.requireNonNull(position, "position");
        return this.createSnapshot(position.getX(), position.getY(), position.getZ());
    }

    public BlockSnapshot createSnapshot(int var1, int var2, int var3);

    public boolean restoreSnapshot(BlockSnapshot var1, boolean var2, BlockChangeFlag var3);

    default public boolean restoreSnapshot(Vector3i position, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        Objects.requireNonNull(position, "position");
        return this.restoreSnapshot(position.getX(), position.getY(), position.getZ(), Objects.requireNonNull(snapshot, "snapshot"), force, Objects.requireNonNull(flag, "flag"));
    }

    public boolean restoreSnapshot(int var1, int var2, int var3, BlockSnapshot var4, boolean var5, BlockChangeFlag var6);

    public Path getDirectory();

    public WorldStorage getWorldStorage();

    public boolean save() throws IOException;

    public boolean unloadChunk(Chunk var1);

    public void triggerExplosion(Explosion var1);

    @Override
    public Collection<ServerPlayer> getPlayers();

    public Collection<? extends Entity> getEntities();

    public Collection<Raid> getRaids();

    public Optional<Raid> getRaidAt(Vector3i var1);
}

