/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.registry.SpongeGameRegistry;
import org.spongepowered.common.scheduler.AsyncScheduler;
import org.spongepowered.common.scheduler.ServerScheduler;
import org.spongepowered.common.util.Constants;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.PluginKeys;

@Singleton
public final class SpongeCommon {
    public static final String ECOSYSTEM_ID = "sponge";
    public static final SpongeMinecraftVersion MINECRAFT_VERSION = new SpongeMinecraftVersion(Constants.MINECRAFT_VERSION, Constants.MINECRAFT_PROTOCOL_VERSION);
    @Inject
    private static @Nullable SpongeGame game;
    private static @Nullable PluginContainer activePlugin;

    private SpongeCommon() {
    }

    private static <T> T check(@Nullable T instance) {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"SpongeCommon has not been initialized!");
        return instance;
    }

    public static Logger getLogger() {
        return ((Launch)Launch.getInstance()).getLogger();
    }

    public static boolean isInitialized() {
        return game != null;
    }

    public static SpongeGame getGame() {
        return SpongeCommon.check(game);
    }

    public static MinecraftServer getServer() {
        return (MinecraftServer)Sponge.getServer();
    }

    public static SpongeGameRegistry getRegistry() {
        return (SpongeGameRegistry)Sponge.getRegistry();
    }

    public static ServerScheduler getServerScheduler() {
        return (ServerScheduler)Sponge.getServer().getScheduler();
    }

    public static AsyncScheduler getAsyncScheduler() {
        return SpongeCommon.getGame().getAsyncScheduler();
    }

    public static Path getGameDirectory() {
        return (Path)((Launch)Launch.getInstance()).getPluginEngine().getPluginEnvironment().getBlackboard().get(PluginKeys.BASE_DIRECTORY).orElseThrow(() -> new IllegalStateException("No game directory has been set in the launcher!"));
    }

    public static Path getPluginConfigDirectory() {
        return Paths.get(SpongeConfigs.getCommon().get().general.configDir.getParsed(), new String[0]);
    }

    public static Path getSpongeConfigDirectory() {
        return SpongeCommon.getGameDirectory().resolve("config");
    }

    @Deprecated
    public static PluginContainer getMinecraftPlugin() {
        return ((Launch)Launch.getInstance()).getMinecraftPlugin();
    }

    @Deprecated
    public static PluginContainer getPlugin() {
        return ((Launch)Launch.getInstance()).getCommonPlugin();
    }

    @Deprecated
    public static List<PluginContainer> getInternalPlugins() {
        return ((Launch)Launch.getInstance()).getLauncherPlugins();
    }

    public static PluginContainer getActivePlugin() {
        if (activePlugin == null) {
            return ((Launch)Launch.getInstance()).getMinecraftPlugin();
        }
        return activePlugin;
    }

    public static void setActivePlugin(@Nullable PluginContainer plugin) {
        activePlugin = plugin;
    }

    public static boolean postEvent(Event event) {
        return Sponge.getEventManager().post(event);
    }

    @Deprecated
    public static boolean postEvent(Event event, boolean allowClientThread) {
        return Sponge.getEventManager().post(event);
    }

    public static int directionToIndex(Direction direction) {
        switch (direction) {
            case NORTH: 
            case NORTHEAST: 
            case NORTHWEST: {
                return 0;
            }
            case SOUTH: 
            case SOUTHEAST: 
            case SOUTHWEST: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unexpected direction");
    }

    public static Direction getCardinalDirection(Direction direction) {
        switch (direction) {
            case NORTH: 
            case NORTHEAST: 
            case NORTHWEST: {
                return Direction.NORTH;
            }
            case SOUTH: 
            case SOUTHEAST: 
            case SOUTHWEST: {
                return Direction.SOUTH;
            }
            case EAST: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.WEST;
            }
        }
        throw new IllegalArgumentException("Unexpected direction");
    }

    public static Direction getSecondaryDirection(Direction direction) {
        switch (direction) {
            case NORTHEAST: 
            case SOUTHEAST: {
                return Direction.EAST;
            }
            case NORTHWEST: 
            case SOUTHWEST: {
                return Direction.WEST;
            }
        }
        return Direction.NONE;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            SpongeGame game = game;
            if (game != null) {
                try {
                    game.getConfigManager().close();
                }
                catch (IOException e) {
                    SpongeCommon.getLogger().error("Failed to shut down configuration watch service", (Throwable)e);
                }
            }
        }, "Sponge shutdown thread"));
    }
}

