/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.adventure.AdventureTextComponent;

public abstract class NativeComponentRenderer<C> {
    static final NativeComponentRenderer<Locale> INSTANCE = new NativeComponentRenderer<Locale>(){

        @Override
        public MessageFormat translate(@NonNull String key, @NonNull Locale locale) {
            return GlobalTranslator.get().translate(key, locale);
        }
    };

    public static @NonNull ITextComponent apply(ITextComponent input, Locale locale) {
        if (input instanceof AdventureTextComponent) {
            return ((AdventureTextComponent)input).rendered(locale);
        }
        return NativeComponentRenderer.get().render(input.func_230532_e_(), locale);
    }

    public static @NonNull NativeComponentRenderer<Locale> get() {
        return INSTANCE;
    }

    protected abstract @Nullable MessageFormat translate(@NonNull String var1, @NonNull C var2);

    public ITextComponent render(@NonNull IFormattableTextComponent component, @NonNull C context) {
        if (component instanceof TranslationTextComponent) {
            component = this.renderTranslatable((TranslationTextComponent)component, context);
        } else {
            this.renderSiblings((ITextComponent)component, context);
        }
        HoverEvent hover = component.func_150256_b().func_150210_i();
        if (hover != null) {
            component.func_230530_a_(component.func_150256_b().func_240716_a_(this.renderHoverEvent(hover, context)));
        }
        return component;
    }

    private HoverEvent renderHoverEvent(HoverEvent input, @NonNull C context) {
        HoverEvent.Action action = input.func_150701_a();
        if (action == HoverEvent.Action.field_230550_a_) {
            ITextComponent original = (ITextComponent)input.func_240662_a_(HoverEvent.Action.field_230550_a_);
            return new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)this.render(original.func_230532_e_(), context));
        }
        if (action == HoverEvent.Action.field_230552_c_) {
            HoverEvent.EntityHover data = (HoverEvent.EntityHover)input.func_240662_a_(HoverEvent.Action.field_230552_c_);
            if (data.field_240679_c_ != null) {
                ITextComponent rendered = this.render(data.field_240679_c_.func_230532_e_(), context);
                return new HoverEvent(HoverEvent.Action.field_230552_c_, (Object)new HoverEvent.EntityHover(data.field_240677_a_, data.field_240678_b_, rendered));
            }
        }
        return input;
    }

    protected @NonNull IFormattableTextComponent renderTranslatable(@NonNull TranslationTextComponent component, @NonNull C context) {
        StringTextComponent result;
        MessageFormat format = this.translate(component.func_150268_i(), context);
        if (format == null) {
            Object[] args = component.func_150271_j();
            if (args.length > 0) {
                int size = args.length;
                for (int i = 0; i < size; ++i) {
                    if (!(args[i] instanceof ITextComponent)) continue;
                    args[i] = this.render(((ITextComponent)args[i]).func_230532_e_(), context);
                }
            }
            this.renderSiblings((ITextComponent)component, context);
            return component;
        }
        Object[] args = component.func_150271_j();
        if (args.length == 0) {
            result = new StringTextComponent(format.format(null, new StringBuffer(), null).toString());
        } else {
            result = new StringTextComponent("");
            Object[] nulls = new Object[args.length];
            StringBuffer sb = format.format(nulls, new StringBuffer(), (FieldPosition)null);
            AttributedCharacterIterator it = format.formatToCharacterIterator(nulls);
            while (it.getIndex() < it.getEndIndex()) {
                int end = it.getRunLimit();
                Integer index = (Integer)it.getAttribute(MessageFormat.Field.ARGUMENT);
                if (index != null && args[index] instanceof ITextComponent) {
                    result.func_230529_a_(this.render(((ITextComponent)args[index]).func_230532_e_(), context));
                } else {
                    result.func_230529_a_((ITextComponent)new StringTextComponent(sb.substring(it.getIndex(), end)));
                }
                it.setIndex(end);
            }
        }
        result.func_230530_a_(component.func_150256_b());
        this.renderSiblings((ITextComponent)component, context, (idx, rendered) -> result.func_230529_a_(rendered));
        return result;
    }

    private void renderSiblings(ITextComponent component, C context) {
        this.renderSiblings(component, context, component.func_150253_a()::set);
    }

    private void renderSiblings(ITextComponent component, C context, SiblingConsumer consumer) {
        List siblings = component.func_150253_a();
        for (int i = 0; i < siblings.size(); ++i) {
            ITextComponent original = (ITextComponent)siblings.get(i);
            ITextComponent rendered = this.render(original.func_230532_e_(), context);
            consumer.accept(i, rendered);
        }
    }

    @FunctionalInterface
    static interface SiblingConsumer {
        public void accept(int var1, ITextComponent var2);
    }
}

