/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.util.TypeTokens;

public final class SpongeCallback {
    private final Cache<UUID, Consumer<CommandCause>> executors = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(10L)).build();
    private @MonotonicNonNull Parameter.Key<Consumer<CommandCause>> executorKey;

    public Command.Parameterized createCommand() {
        if (this.executorKey == null) {
            this.executorKey = Parameter.key("key", TypeTokens.COMMAND_CAUSE_CONSUMER);
        }
        this.executors.invalidateAll();
        return Command.builder().setShortDescription((Component)Component.text((String)"Execute a callback registered as part of a TextComponent. Primarily for internal use")).parameter((Parameter)Parameter.builder(TypeTokens.COMMAND_CAUSE_CONSUMER).setKey(this.executorKey).parser(new CallbackValueParameter()).build()).setExecutor(this::commandCallback).build();
    }

    public UUID registerCallback(Consumer<CommandCause> causeConsumer) {
        UUID newKey = UUID.randomUUID();
        this.executors.put((Object)newKey, causeConsumer);
        return newKey;
    }

    public CommandResult commandCallback(@NonNull CommandContext context) throws CommandException {
        context.requireOne(this.executorKey).accept(context.getCause());
        return CommandResult.success();
    }

    private final class CallbackValueParameter
    implements ValueParameter<Consumer<CommandCause>> {
        private CallbackValueParameter() {
        }

        @Override
        public @NonNull List<String> complete(@NonNull CommandContext context, String currentInput) {
            return SpongeCallback.this.executors.asMap().keySet().stream().map(UUID::toString).filter(x -> x.startsWith(currentInput)).collect(Collectors.toList());
        }

        @Override
        public @NonNull Optional<? extends Consumer<CommandCause>> getValue(@NonNull Parameter.Key<? super Consumer<CommandCause>> parameterKey,  @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
            String next = reader.parseString();
            try {
                UUID id = UUID.fromString(next);
                Consumer ret = (Consumer)SpongeCallback.this.executors.getIfPresent((Object)id);
                if (ret == null) {
                    throw reader.createException((Component)Component.text((String)"The callback you provided was not valid. Keep in mind that callbacks will expire after 10 minutes, so you might want to consider clicking faster next time!"));
                }
                return Optional.of(ret);
            }
            catch (IllegalArgumentException ex) {
                throw reader.createException((Component)Component.text((String)("Input " + next + " was not a valid UUID")));
            }
        }
    }
}

