/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config.common;

import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class ExploitCategory {
    @Setting(value="mark-chunks-as-dirty-on-entity-list-modification")
    @Comment(value="Enables forcing chunks to save when an entity is added\nor removed from said chunk. This is a partial fix for\nsome exploits using vehicles.See https://github.com/PaperMC/Paper/blob/fd1bd5223a461b6d98280bb8f2d67280a30dd24a/Spigot-Server-Patches/0306-Mark-chunk-dirty-anytime-entities-change-to-guarante.patch\n(Only affects SpongeVanilla)")
    public boolean markChunksAsDirtyOnEntityListModification = true;
    @Setting(value="update-tracked-chunk-on-entity-move")
    @Comment(value="Enables forcing a chunk-tracking refresh on entity movement.\nThis enables a guarantee that the entity is tracked in the \nproper chunk when moving.https://github.com/PaperMC/Paper/blob/fd1bd5223a461b6d98280bb8f2d67280a30dd24a/Spigot-Server-Patches/0315-Always-process-chunk-registration-after-moving.patch\n(Only affects SpongeVanilla)")
    public boolean updateTrackedChunkOnEntityMove = true;
    @Setting(value="load-chunk-on-entity-position-set")
    @Comment(value="Enables focing a chunk load when an entity position\nis set. Usually due to teleportation, vehicle movement\netc. can a position lead an entity to no longer exist\nwithin it's currently marked and tracked chunk. This will\nenable that chunk for the position is loaded. Part of several\nexploits.See https://github.com/PaperMC/Paper/blob/fd1bd5223a461b6d98280bb8f2d67280a30dd24a/Spigot-Server-Patches/0335-Ensure-chunks-are-always-loaded-on-hard-position-set.patch\n(Only affects SpongeVanilla)")
    public boolean loadChunkOnEntityPositionSet = true;
    @Setting(value="sync-player-positions-for-vehicle-movement")
    @Comment(value="Enables forcing updates to the player's location on vehicle movement.\nThis is partially required to update the server's understanding of\nwhere the player exists, and allows chunk loading issues to be avoided\nwith laggy connections and/or hack clients.See https://github.com/PaperMC/Paper/blob/fd1bd5223a461b6d98280bb8f2d67280a30dd24a/Spigot-Server-Patches/0378-Sync-Player-Position-to-Vehicles.patch\n(Only affects SpongeVanilla)")
    public boolean syncPlayerPositionsForVehicleMovement = true;
    @Setting(value="max-book-page-size")
    @Comment(value="Controls the maximum size of a book page. (Default: 32767)")
    public int maxBookPageSize = Short.MAX_VALUE;
    @Setting(value="max-book-size")
    @Comment(value="Controls the maximum size of a book")
    public int maxBookSize = this.maxBookPageSize * 1000;
}

