/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config.core;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;

public final class FileMovingConfigurationTransformation
implements ConfigurationTransformation {
    private final Set<NodePath> paths;
    private final ConfigurationLoader<?> destinationLoader;
    private final boolean override;

    public FileMovingConfigurationTransformation(Set<NodePath> paths, ConfigurationLoader<?> destinationLoader, boolean override) {
        this.paths = ImmutableSet.copyOf(paths);
        this.destinationLoader = destinationLoader;
        this.override = override;
    }

    @Override
    public void apply(@NonNull ConfigurationNode oldConfig) throws ConfigurateException {
        Object newConfig = this.destinationLoader.load();
        boolean acted = false;
        for (NodePath path : this.paths) {
            ConfigurationNode source = oldConfig.node(path);
            if (source.virtual()) continue;
            acted = true;
            if (this.override) {
                newConfig.node(path).from(source);
            } else {
                newConfig.node(path).mergeFrom(source);
            }
            source.raw(null);
        }
        if (acted) {
            this.destinationLoader.save((ConfigurationNode)newConfig);
        }
    }
}

