/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config.core;

import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.plugin.Blackboard;
import org.spongepowered.plugin.PluginEnvironment;
import org.spongepowered.plugin.PluginKeys;

public final class TokenHoldingString {
    static final ScalarSerializer<TokenHoldingString> SERIALIZER = new Serializer();
    private static final Pattern TOKEN_MATCH = Pattern.compile("\\$\\{([^}]+)}");
    private static final Map<String, Function<PluginEnvironment, String>> TOKENS = new HashMap<String, Function<PluginEnvironment, String>>();
    private final String plainValue;
    private final String parsedValue;

    public static TokenHoldingString of(String input) {
        return new TokenHoldingString(input, TokenHoldingString.parsePlaceholders(input));
    }

    private static void register(String token, Blackboard.Key<?> getter) {
        TokenHoldingString.register(token, (PluginEnvironment env) -> {
            Object value = env.getBlackboard().get(getter).orElse(null);
            return value == null ? null : value.toString();
        });
    }

    private static void register(String token, Function<PluginEnvironment, String> getter) {
        TOKENS.put(token.toLowerCase(Locale.ROOT), getter);
    }

    private static String parsePlaceholders(String input) {
        PluginEnvironment env = SpongeConfigs.getPluginEnvironment();
        Matcher matcher = TOKEN_MATCH.matcher(input);
        if (!matcher.find()) {
            return input;
        }
        StringBuffer result = new StringBuffer();
        do {
            String token;
            Function<PluginEnvironment, String> replacer;
            String replaced = (replacer = TOKENS.get((token = matcher.group(1)).toLowerCase())) == null ? "" : replacer.apply(env);
            matcher.appendReplacement(result, replaced == null ? "" : replaced);
        } while (matcher.find());
        matcher.appendTail(result);
        return result.toString();
    }

    private TokenHoldingString(String plain, String parsed) {
        this.plainValue = plain;
        this.parsedValue = parsed;
    }

    public String getPlain() {
        return this.plainValue;
    }

    public String getParsed() {
        return this.parsedValue;
    }

    static {
        TokenHoldingString.register("CANONICAL_GAME_DIR", PluginKeys.BASE_DIRECTORY);
        TokenHoldingString.register("CANONICAL_MODS_DIR", (PluginEnvironment env) -> {
            List directories = env.getBlackboard().get(PluginKeys.PLUGIN_DIRECTORIES).orElse(Collections.emptyList());
            return directories.isEmpty() ? null : ((Path)directories.get(0)).toString();
        });
    }

    static final class Serializer
    extends ScalarSerializer<TokenHoldingString> {
        Serializer() {
            super(TokenHoldingString.class);
        }

        @Override
        public TokenHoldingString deserialize(Type type, Object obj) {
            return TokenHoldingString.of(obj.toString());
        }

        @Override
        public Object serialize(TokenHoldingString item, Predicate<Class<?>> typeSupported) {
            return item.getPlain();
        }
    }
}

