/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeBlockSnapshot
implements BlockSnapshot,
SpongeImmutableDataHolder<BlockSnapshot>,
DataContainerHolder.Immutable<BlockSnapshot>,
DataCompoundHolder {
    private final BlockState blockState;
    private final ResourceKey worldKey;
    private final Vector3i pos;
    final @Nullable CompoundNBT compound;
    private final BlockPos blockPos;
    private final SpongeBlockChangeFlag changeFlag;
    @Nullable WeakReference<net.minecraft.world.server.ServerWorld> world;
    public @MonotonicNonNull BlockChange blockChange;

    SpongeBlockSnapshot(SpongeBlockSnapshotBuilder builder) {
        this.blockState = Objects.requireNonNull(builder.blockState);
        this.worldKey = Objects.requireNonNull(builder.worldKey);
        this.pos = Objects.requireNonNull(builder.coordinates);
        this.blockPos = VecHelper.toBlockPos(this.pos);
        this.compound = builder.compound;
        this.changeFlag = builder.flag;
        this.world = builder.worldRef;
        builder.worldRef = null;
    }

    @Override
    public BlockState getState() {
        return this.blockState;
    }

    @Override
    public BlockSnapshot withState(BlockState blockState) {
        return this.createBuilder().blockState(blockState).build();
    }

    @Override
    public BlockSnapshot withContainer(DataContainer container) {
        return (BlockSnapshot)SpongeBlockSnapshotBuilder.pooled().build(container).get();
    }

    @Override
    public ResourceKey getWorld() {
        return this.worldKey;
    }

    @Override
    public Vector3i getPosition() {
        return this.pos;
    }

    @Override
    public Optional<ServerLocation> getLocation() {
        return this.getServerWorld().map(world -> ServerLocation.of((ServerWorld)world, this.pos));
    }

    @Override
    public BlockSnapshot withLocation(ServerLocation location) {
        throw new UnsupportedOperationException("Not implemented yet, please fix when this is called");
    }

    @Override
    public boolean restore(boolean force, BlockChangeFlag flag) {
        Optional optionalWorld = Optional.ofNullable(this.world.get());
        if (!optionalWorld.isPresent()) {
            return false;
        }
        net.minecraft.world.server.ServerWorld world = (net.minecraft.world.server.ServerWorld)optionalWorld.get();
        try (Object context = BlockPhase.State.RESTORING_BLOCKS.createPhaseContext(PhaseTracker.SERVER);){
            ((PhaseContext)context).buildAndSwitch();
            BlockPos pos = VecHelper.toBlockPos(this.pos);
            if (!World.func_175701_a((BlockPos)pos)) {
                boolean bl = false;
                return bl;
            }
            net.minecraft.block.BlockState current = world.func_180495_p(pos);
            net.minecraft.block.BlockState replaced = (net.minecraft.block.BlockState)this.blockState;
            if (!(force || current.func_177230_c() == replaced.func_177230_c() && current == replaced)) {
                boolean bl = false;
                return bl;
            }
            world.func_175713_t(pos);
            world.func_180501_a(pos, replaced, BlockChangeFlagManager.andNotifyClients(flag).getRawFlag());
            if (this.compound != null) {
                @Nullable TileEntity te = world.func_175625_s(pos);
                if (te != null) {
                    te.func_230337_a_((net.minecraft.block.BlockState)this.blockState, this.compound);
                } else {
                    try {
                        te = TileEntity.func_235657_b_((net.minecraft.block.BlockState)((net.minecraft.block.BlockState)this.blockState), (CompoundNBT)this.compound);
                        if (te != null) {
                            world.func_217349_x(pos).func_177426_a(pos, te);
                        }
                    }
                    catch (Exception e) {
                        PrettyPrinter printer = new PrettyPrinter(60).add("Unable to restore").centre().hr().add("A mod is not correctly deserializing a TileEntity that is being restored. ").addWrapped(60, "Note that this is not the fault of Sponge. Sponge is understanding that a block is supposed to have a TileEntity, but the mod is breaking the contracton how to re-create the tile entity. Please open an issue with the offending mod.", new Object[0]).add("Here's the provided compound:");
                        printer.add();
                        try {
                            printer.addWrapped(80, "%s : %s", "This compound", this.compound);
                        }
                        catch (Throwable error) {
                            printer.addWrapped(80, "Unable to get the string of this compound. Printing out some of the entries to better assist", new Object[0]);
                        }
                        printer.add().add("Desired World: " + this.worldKey).add("Position: " + this.pos).add("Desired BlockState: " + this.blockState);
                        printer.add();
                        printer.log(SpongeCommon.getLogger(), Level.ERROR);
                        boolean bl = true;
                        if (context != null) {
                            if (var6_6 != null) {
                                try {
                                    ((PhaseContext)context).close();
                                }
                                catch (Throwable throwable) {
                                    var6_6.addSuppressed(throwable);
                                }
                            } else {
                                ((PhaseContext)context).close();
                            }
                        }
                        return bl;
                    }
                }
                if (te != null) {
                    te.func_70296_d();
                }
            }
            world.func_72863_F().func_217217_a(pos);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Optional<UUID> getCreator() {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getNotifier() {
        return Optional.empty();
    }

    @Override
    public Optional<BlockEntityArchetype> createArchetype() {
        throw new UnsupportedOperationException("Not implemented yet, please fix when this is called");
    }

    @Override
    public BlockSnapshot withRawData(DataView container) throws InvalidDataException {
        throw new UnsupportedOperationException("Not implemented yet, please fix when this is called");
    }

    @Override
    public boolean validateRawData(DataView container) {
        throw new UnsupportedOperationException("Not implemented yet, please fix when this is called");
    }

    @Override
    public BlockSnapshot copy() {
        return this;
    }

    @Override
    public int getContentVersion() {
        throw new UnsupportedOperationException("Not implemented yet, please fix when this is called");
    }

    @Override
    public DataContainer toContainer() {
        throw new UnsupportedOperationException("Not implemented yet, please fix when this is called");
    }

    public Optional<net.minecraft.world.server.ServerWorld> getServerWorld() {
        net.minecraft.world.server.ServerWorld world;
        net.minecraft.world.server.ServerWorld serverWorld = world = this.world != null ? (net.minecraft.world.server.ServerWorld)this.world.get() : null;
        if (world == null && (world = (net.minecraft.world.server.ServerWorld)Sponge.getServer().getWorldManager().world(this.worldKey).orElse(null)) != null) {
            this.world = new WeakReference<net.minecraft.world.server.ServerWorld>(world);
        }
        return Optional.ofNullable(world);
    }

    public Optional<CompoundNBT> getCompound() {
        return this.compound == null ? Optional.empty() : Optional.of(this.compound.func_74737_b());
    }

    public SpongeBlockSnapshotBuilder createBuilder() {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        builder.blockState(this.blockState).position(this.pos);
        if (this.world != null && this.world.get() != null) {
            builder.world((net.minecraft.world.server.ServerWorld)this.world.get());
        } else {
            builder.world(this.worldKey);
        }
        if (this.compound != null) {
            builder.addUnsafeCompound(this.compound);
        }
        return builder;
    }

    @Override
    public DataContainer data$getDataContainer() {
        if (this.compound == null) {
            return DataContainer.createNew();
        }
        return NBTTranslator.INSTANCE.translate(this.compound);
    }

    @Override
    public BlockSnapshot data$withDataContainer(DataContainer container) {
        SpongeBlockSnapshotBuilder builder = this.createBuilder();
        builder.compound = NBTTranslator.INSTANCE.translate(container);
        return builder.build();
    }

    @Override
    public CompoundNBT data$getCompound() {
        return this.compound == null ? new CompoundNBT() : this.compound.func_74737_b();
    }

    @Override
    public void data$setCompound(CompoundNBT nbt) {
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.BLOCK_ENTITY;
    }

    public SpongeBlockChangeFlag getChangeFlag() {
        return this.changeFlag;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeBlockSnapshot that = (SpongeBlockSnapshot)o;
        return this.changeFlag == that.changeFlag && Objects.equals(this.worldKey, that.worldKey) && Objects.equals(this.pos, that.pos) && Objects.equals(this.compound, that.compound);
    }

    public int hashCode() {
        return Objects.hash(this.blockState, this.worldKey, this.pos, this.changeFlag, this.compound);
    }

    public String toString() {
        return new StringJoiner(", ", SpongeBlockSnapshot.class.getSimpleName() + "[", "]").add("world=" + this.worldKey).add("position=" + this.blockPos).add("blockState=" + this.blockState).toString();
    }
}

