/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetype;
import org.spongepowered.common.bridge.block.BlockStateBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.util.Constants;

public final class SpongeBlockEntityArchetypeBuilder
extends AbstractDataBuilder<BlockEntityArchetype>
implements BlockEntityArchetype.Builder {
    @MonotonicNonNull BlockState blockState;
    @MonotonicNonNull BlockEntityType type;
    @Nullable DataContainer data;

    public SpongeBlockEntityArchetypeBuilder() {
        super(BlockEntityArchetype.class, 1);
    }

    @Override
    public BlockEntityArchetype.Builder reset() {
        this.blockState = null;
        this.type = null;
        this.data = null;
        return this;
    }

    @Override
    public <V> BlockEntityArchetype.Builder add(Key<? extends Value<V>> key, V value) {
        return null;
    }

    @Override
    public BlockEntityArchetype.Builder from(BlockEntityArchetype value) {
        this.type = value.getBlockEntityType();
        this.blockState = value.getState();
        this.data = value.getBlockEntityData();
        return this;
    }

    @Override
    public BlockEntityArchetype.Builder state(BlockState state) {
        net.minecraft.block.BlockState blockState = (net.minecraft.block.BlockState)state;
        if (!((BlockStateBridge)blockState).bridge$hasTileEntity()) {
            new IllegalArgumentException("BlockState: " + state + " does not provide TileEntities!").printStackTrace();
        }
        if (this.blockState != state) {
            this.data = null;
        }
        this.blockState = state;
        return this;
    }

    @Override
    public BlockEntityArchetype.Builder blockEntity(BlockEntityType blockEntityType) {
        this.type = Objects.requireNonNull(blockEntityType, "BlockEntityType cannot be null");
        return this;
    }

    @Override
    public BlockEntityArchetype.Builder from(ServerLocation location) {
        BlockEntity tileEntity = location.getBlockEntity().orElseThrow(() -> new IllegalArgumentException("There is no block entity available at the provided location: " + location));
        return this.blockEntity(tileEntity);
    }

    @Override
    public BlockEntityArchetype.Builder blockEntity(BlockEntity blockEntity) {
        if (!(Objects.requireNonNull(blockEntity, "BlockEntity cannot be null!") instanceof TileEntity)) {
            throw new IllegalArgumentException("BlockEntity is not compatible with this implementation!");
        }
        CompoundNBT compound = new CompoundNBT();
        ((TileEntity)blockEntity).func_189515_b(compound);
        compound.func_82580_o("x");
        compound.func_82580_o("y");
        compound.func_82580_o("z");
        String tileId = compound.func_74779_i("id");
        compound.func_82580_o("id");
        compound.func_74778_a("Id", tileId);
        this.data = NBTTranslator.INSTANCE.translate(compound);
        this.blockState = blockEntity.getBlock();
        this.type = blockEntity.getType();
        return this;
    }

    @Override
    public BlockEntityArchetype.Builder blockEntityData(DataView dataView) {
        DataContainer copy;
        this.data = copy = Objects.requireNonNull(dataView, "DataView cannot be null!").copy();
        return this;
    }

    @Override
    public BlockEntityArchetype build() {
        if (this.blockState == null) {
            throw new IllegalStateException("BlockState cannot be null!");
        }
        if (this.type == null) {
            throw new IllegalStateException("BlockEntityType cannot be null!");
        }
        if (this.data == null) {
            this.data = DataContainer.createNew();
        }
        return new SpongeBlockEntityArchetype(this);
    }

    @Override
    protected Optional<BlockEntityArchetype> buildContent(DataView container) throws InvalidDataException {
        SpongeBlockEntityArchetypeBuilder builder = new SpongeBlockEntityArchetypeBuilder();
        if (!container.contains(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_TYPE, Constants.Sponge.BlockEntityArchetype.BLOCK_STATE)) {
            throw new InvalidDataException("Missing the BlockEntityType and BlockState! Cannot re-construct a BlockEntityArchetype!");
        }
        builder.blockEntity(container.getRegistryValue(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_TYPE, RegistryTypes.BLOCK_ENTITY_TYPE).orElseThrow(() -> new InvalidDataException("Could not deserialize a BlockEntityType!")));
        builder.state(container.getSerializable(Constants.Sponge.BlockEntityArchetype.BLOCK_STATE, BlockState.class).orElseThrow(() -> new InvalidDataException("Could not deserialize a BlockState!")));
        if (container.contains(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_DATA)) {
            builder.blockEntityData(container.getView(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_DATA).orElseThrow(() -> new InvalidDataException("No DataView found for the 'TileEntity' data tag!")));
        }
        return Optional.of(builder.build());
    }
}

