/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.argument.CustomArgumentParser;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNodeBuilder;
import org.spongepowered.common.command.brigadier.tree.SpongeCommandExecutorWrapper;
import org.spongepowered.common.command.brigadier.tree.SpongeFlagLiteralCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeLiteralCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeNode;
import org.spongepowered.common.command.parameter.SpongeParameterKey;
import org.spongepowered.common.command.parameter.SpongeParameterValue;
import org.spongepowered.common.command.parameter.multi.SpongeFirstOfParameter;
import org.spongepowered.common.command.parameter.multi.SpongeMultiParameter;

public final class SpongeParameterTranslator {
    public static final SpongeParameterTranslator INSTANCE = new SpongeParameterTranslator();

    private SpongeParameterTranslator() {
    }

    public Collection<LiteralCommandNode<CommandSource>> createCommandTree(Command.Parameterized command, Collection<String> aliases) {
        if (aliases.isEmpty()) {
            throw new IllegalArgumentException("Aliases must not be empty.");
        }
        Collection sortedAliases = aliases.stream().sorted().collect(Collectors.toList());
        Iterator aliasIterator = sortedAliases.iterator();
        String baseAlias = (String)aliasIterator.next();
        SpongeCommandExecutorWrapper executor = command.getExecutor().map(SpongeCommandExecutorWrapper::new).orElse(null);
        LiteralArgumentBuilder basicNode = LiteralArgumentBuilder.literal((String)baseAlias);
        basicNode.requires(command.getExecutionRequirements());
        if (command.isTerminal() && executor != null) {
            basicNode.executes((Command)executor);
        }
        SpongeLiteralCommandNode commandNode = new SpongeLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)basicNode);
        if (executor != null) {
            this.createAndAttachNode(Collections.singleton(commandNode), command.parameters(), executor, true, true);
        }
        for (Parameter.Subcommand subcommand : command.subcommands()) {
            Collection<LiteralCommandNode<CommandSource>> builtSubcommand = this.createCommandTree(subcommand.getCommand(), subcommand.getAliases());
            builtSubcommand.forEach(commandNode::addChild);
        }
        this.createFlags(commandNode, command.flags(), executor);
        ArrayList<SpongeLiteralCommandNode> allCommandNodes = new ArrayList<SpongeLiteralCommandNode>();
        allCommandNodes.add(commandNode);
        while (aliasIterator.hasNext()) {
            LiteralArgumentBuilder redirectedNode = LiteralArgumentBuilder.literal((String)((String)aliasIterator.next()));
            redirectedNode.executes(commandNode.getCommand());
            redirectedNode.requires(commandNode.getRequirement());
            redirectedNode.redirect((CommandNode)commandNode);
            allCommandNodes.add(new SpongeLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)redirectedNode));
        }
        return Collections.unmodifiableCollection(allCommandNodes);
    }

    private void createFlags(LiteralCommandNode<CommandSource> node, List<Flag> flags, @Nullable SpongeCommandExecutorWrapper wrapper) {
        ArrayList<CommandNode> nodesToAddChildrenTo = new ArrayList<CommandNode>();
        for (Flag flag : flags) {
            Iterator<String> aliasIterator = flag.getAliases().iterator();
            LiteralArgumentBuilder flagLiteral = LiteralArgumentBuilder.literal((String)aliasIterator.next());
            flagLiteral.requires(flag.getRequirement());
            SpongeFlagLiteralCommandNode flagNode = new SpongeFlagLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)flagLiteral, flag);
            Collection<SpongeFlagLiteralCommandNode> toBeRedirected = flag.getAssociatedParameter().isPresent() ? this.createAndAttachNode(Collections.singleton(flagNode), Collections.singletonList(flag.getAssociatedParameter().get()), wrapper, node.getCommand() != null, false) : Collections.singletonList(flagNode);
            for (CommandNode commandNode : toBeRedirected) {
                if (commandNode instanceof SpongeNode && ((SpongeNode)commandNode).canForceRedirect()) {
                    ((SpongeNode)commandNode).forceRedirect((CommandNode<CommandSource>)node);
                    continue;
                }
                nodesToAddChildrenTo.add(commandNode);
            }
            node.addChild((CommandNode)flagNode);
            while (aliasIterator.hasNext()) {
                LiteralArgumentBuilder nextFlag = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)aliasIterator.next()).executes(flagNode.getCommand());
                if (flagNode.getRedirect() != null) {
                    nextFlag.redirect(flagNode.getRedirect());
                } else {
                    nextFlag.redirect((CommandNode)flagNode);
                }
                node.addChild((CommandNode)new SpongeFlagLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)nextFlag, flag));
            }
        }
        node.getChildren().forEach(x -> nodesToAddChildrenTo.forEach(y -> y.addChild(x)));
    }

    private Collection<? extends CommandNode<CommandSource>> createAndAttachNode(Collection<? extends CommandNode<CommandSource>> parents, List<Parameter> children, @Nullable SpongeCommandExecutorWrapper executorWrapper, boolean shouldTerminate, boolean allowSubcommands) {
        HashSet<? extends CommandNode<CommandSource>> nodesToAttachTo = new HashSet<CommandNode<CommandSource>>(parents);
        ListIterator<Parameter> parameterIterator = children.listIterator();
        while (parameterIterator.hasNext()) {
            ArrayList<Object> parametersToAttachTo;
            boolean isTerminal;
            boolean isOptional;
            Parameter parameter = parameterIterator.next();
            boolean bl = parameterIterator.hasNext();
            if (parameter instanceof Parameter.Subcommand) {
                Parameter.Subcommand subcommands = (Parameter.Subcommand)parameter;
                if (!allowSubcommands) {
                    throw new IllegalStateException("Subcommands are not allowed for this element (subcommands were " + String.join((CharSequence)", ", subcommands.getAliases() + ")!"));
                }
                if (bl) {
                    throw new IllegalStateException("A parameter cannot be placed after a subcommand parameter!");
                }
                Collection<LiteralCommandNode<CommandSource>> nodes = this.createCommandTree(subcommands.getCommand(), subcommands.getAliases());
                for (LiteralCommandNode<CommandSource> literalCommandNode : nodes) {
                    nodesToAttachTo.forEach(x -> x.addChild((CommandNode)node));
                }
                return Collections.emptyList();
            }
            if (parameter instanceof SpongeMultiParameter) {
                isOptional = parameter.isOptional();
                boolean bl2 = isTerminal = bl || parameter.isTerminal();
                if (parameter instanceof SpongeFirstOfParameter) {
                    parametersToAttachTo = new ArrayList();
                    for (Parameter p : ((SpongeFirstOfParameter)parameter).getChildParameters()) {
                        Collection<? extends CommandNode<CommandSource>> branchNodesToAttachTo = this.createAndAttachNode(nodesToAttachTo, Collections.singletonList(p), executorWrapper, isTerminal, allowSubcommands);
                        parametersToAttachTo.addAll(branchNodesToAttachTo);
                    }
                } else {
                    parametersToAttachTo = new ArrayList<CommandNode<CommandSource>>(this.createAndAttachNode(nodesToAttachTo, ((SpongeMultiParameter)parameter).getChildParameters(), executorWrapper, !bl || parameter.isTerminal(), allowSubcommands));
                }
            } else {
                parametersToAttachTo = new ArrayList();
                SpongeParameterValue spongeParameterValue = (SpongeParameterValue)parameter;
                boolean isConsumeAll = spongeParameterValue.willConsumeAllRemaining();
                if (isConsumeAll && bl) {
                    throw new IllegalStateException("A parameter that consumes all must be at the end of a parameter chain.");
                }
                isOptional = spongeParameterValue.isOptional();
                isTerminal = shouldTerminate && !bl || spongeParameterValue.isTerminal();
                StringBuilder suffix = null;
                Set names = nodesToAttachTo.stream().flatMap(x -> x.getChildren().stream()).map(CommandNode::getName).collect(Collectors.toSet());
                String key = spongeParameterValue.getKey().key();
                while (names.contains(key)) {
                    if (suffix == null) {
                        suffix = new StringBuilder(String.valueOf(names.size()));
                    } else {
                        suffix.append("_").append(names.size());
                    }
                    key = key + suffix;
                }
                SpongeArgumentCommandNodeBuilder thisNode = SpongeParameterTranslator.createArgumentNodeBuilders(spongeParameterValue, suffix == null ? null : suffix.toString());
                if (isTerminal) {
                    thisNode.executes(executorWrapper);
                }
                SpongeArgumentCommandNode builtNode = thisNode.build();
                if (isConsumeAll) {
                    builtNode.addChild((CommandNode)((SpongeArgumentCommandNodeBuilder)thisNode.redirect((CommandNode)builtNode)).build());
                }
                parametersToAttachTo.add(builtNode);
                nodesToAttachTo.forEach(x -> x.addChild(builtNode));
            }
            if (!isOptional) {
                nodesToAttachTo.clear();
            }
            nodesToAttachTo.addAll(parametersToAttachTo);
        }
        if (shouldTerminate) {
            for (CommandNode commandNode : nodesToAttachTo) {
                if (!(commandNode instanceof SpongeNode)) continue;
                ((SpongeNode)commandNode).forceExecutor(executorWrapper);
            }
        }
        return nodesToAttachTo;
    }

    private static <T> @NonNull SpongeArgumentCommandNodeBuilder<? extends T> createArgumentNodeBuilders(SpongeParameterValue<T> parameter, @Nullable String suffix) {
        ArgumentParser<T> type = parameter.getArgumentTypeIfStandard();
        if (type == null) {
            type = new CustomArgumentParser<T>(parameter.getParsers(), parameter.getCompleter(), false);
        }
        SpongeArgumentCommandNodeBuilder<T> argumentBuilder = new SpongeArgumentCommandNodeBuilder<T>(SpongeParameterKey.getSpongeKey(parameter.getKey()), type, parameter.getCompleter(), parameter.getValueUsage().orElse(null), suffix);
        argumentBuilder.requires(parameter.getRequirement());
        return argumentBuilder;
    }
}

