/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.dispatcher;

import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.command.CommandSourceBridge;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeNodePermissionCache;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeNode;
import org.spongepowered.common.command.brigadier.tree.SpongeRootCommandNode;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.event.tracking.PhaseTracker;

public final class SpongeCommandDispatcher
extends CommandDispatcher<CommandSource> {
    private ResultConsumer<CommandSource> resultConsumer = (context, success, result) -> {};
    private final SpongeCommandManager commandManager;

    public SpongeCommandDispatcher(SpongeCommandManager commandManager) {
        super((RootCommandNode)new SpongeRootCommandNode());
        this.commandManager = commandManager;
    }

    public LiteralCommandNode<CommandSource> register(LiteralCommandNode<CommandSource> command) {
        this.getRoot().addChild(command);
        return command;
    }

    public void setConsumer(ResultConsumer<CommandSource> consumer) {
        super.setConsumer(consumer);
        this.resultConsumer = consumer;
    }

    public ParseResults<CommandSource> parse(String command, CommandSource source) {
        return this.parse(command, source, false);
    }

    public ParseResults<CommandSource> parse(String command, CommandSource source, boolean isSuggestion) {
        SpongeCommandContextBuilder builder = new SpongeCommandContextBuilder(this, source, (CommandNode<CommandSource>)this.getRoot(), 0);
        return this.parseNodes(true, isSuggestion, (CommandNode<CommandSource>)this.getRoot(), new SpongeStringReader(command), builder);
    }

    public ParseResults<CommandSource> parse(StringReader command, CommandSource source) {
        return this.parse(command, source, false);
    }

    public ParseResults<CommandSource> parse(StringReader command, CommandSource source, boolean isSuggestion) {
        SpongeCommandContextBuilder builder = new SpongeCommandContextBuilder(this, source, (CommandNode<CommandSource>)this.getRoot(), command.getCursor());
        SpongeStringReader reader = new SpongeStringReader(command);
        return this.parseNodes(true, isSuggestion, (CommandNode<CommandSource>)this.getRoot(), reader, builder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(StringReader input, CommandSource source) throws CommandSyntaxException {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            CommandSourceBridge sourceBridge = (CommandSourceBridge)source;
            frame.addContext(EventContextKeys.COMMAND, input.getString());
            sourceBridge.bridge$updateFrameFromICommandSource(frame);
            int n = this.commandManager.process(sourceBridge.bridge$withCurrentCause(), input.getRemaining()).getResult();
            return n;
        }
        catch (CommandException e) {
            throw new net.minecraft.command.CommandException(SpongeAdventure.asVanilla(e.componentMessage()));
        }
    }

    public int execute(ParseResults<CommandSource> parse) throws CommandSyntaxException {
        if (parse.getReader().canRead()) {
            if (parse.getExceptions().size() == 1) {
                throw (CommandSyntaxException)((Object)parse.getExceptions().values().iterator().next());
            }
            if (parse.getContext().getRange().isEmpty()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse.getReader());
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parse.getReader());
        }
        int result = 0;
        int successfulForks = 0;
        boolean forked = false;
        boolean foundCommand = false;
        String command = parse.getReader().getString();
        CommandContext original = parse.getContext().build(command);
        List<CommandContext> contexts = Collections.singletonList(original);
        ArrayList<CommandContext> next = null;
        while (contexts != null) {
            int size = contexts.size();
            for (int i = 0; i < size; ++i) {
                CommandContext context = contexts.get(i);
                CommandContext child = context.getChild();
                if (child != null) {
                    forked |= context.isForked();
                    if (!child.hasNodes()) continue;
                    RedirectModifier modifier = context.getRedirectModifier();
                    if (modifier == null) {
                        if (next == null) {
                            next = new ArrayList<CommandContext>(1);
                        }
                        next.add(child.copyFor(context.getSource()));
                        continue;
                    }
                    try {
                        Collection results = modifier.apply(context);
                        if (results.isEmpty()) continue;
                        if (next == null) {
                            next = new ArrayList(results.size());
                        }
                        for (CommandSource source : results) {
                            next.add(child.copyFor((Object)source));
                        }
                        continue;
                    }
                    catch (CommandSyntaxException ex) {
                        foundCommand = true;
                        this.resultConsumer.onCommandComplete(context, false, 0);
                        if (forked) continue;
                        throw ex;
                    }
                }
                if (context.getCommand() == null) continue;
                foundCommand = true;
                try {
                    int value = context.getCommand().run(context);
                    result += value;
                    this.resultConsumer.onCommandComplete(context, true, value);
                    ++successfulForks;
                    continue;
                }
                catch (CommandSyntaxException ex) {
                    this.resultConsumer.onCommandComplete(context, false, 0);
                    if (forked) continue;
                    throw ex;
                }
            }
            contexts = next;
            next = null;
        }
        if (!foundCommand) {
            this.resultConsumer.onCommandComplete(original, false, 0);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse.getReader());
        }
        return forked ? successfulForks : result;
    }

    private ParseResults<CommandSource> parseNodes(boolean isRoot, boolean isSuggestion, CommandNode<CommandSource> node, SpongeStringReader originalReader, SpongeCommandContextBuilder contextSoFar) {
        CommandSource source = contextSoFar.getSource();
        LinkedHashMap<CommandNode<CommandSource>, CommandSyntaxException> errors = null;
        ArrayList<ParseResults> potentials = null;
        int cursor = originalReader.getCursor();
        Collection nodes = isSuggestion && node instanceof SpongeNode ? ((SpongeNode)node).getRelevantNodesForSuggestions(originalReader) : (originalReader.canRead() ? node.getRelevantNodes((StringReader)originalReader) : (Collection)node.getChildren().stream().filter(n -> n instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)n).getParser().doesNotRead()).collect(Collectors.toList()));
        for (CommandNode<CommandSource> child : nodes) {
            boolean doesNotRead;
            boolean bl = doesNotRead = child instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)child).getParser().doesNotRead();
            if (!SpongeNodePermissionCache.canUse(isRoot, this, child, source)) continue;
            SpongeCommandContextBuilder context = contextSoFar.copy();
            SpongeStringReader reader = new SpongeStringReader(originalReader);
            try {
                try {
                    child.parse((StringReader)reader, (CommandContextBuilder)context);
                }
                catch (RuntimeException ex) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)ex.getMessage());
                }
                if (reader.getCursor() == cursor) {
                    if (isSuggestion && !reader.canRead()) {
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherExpectedArgumentSeparator().createWithContext((ImmutableStringReader)reader);
                    }
                    reader.unskipWhitespace();
                } else if (reader.canRead() && reader.peek() != ' ') {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherExpectedArgumentSeparator().createWithContext((ImmutableStringReader)reader);
                }
            }
            catch (CommandSyntaxException ex) {
                if (errors == null) {
                    errors = new LinkedHashMap<CommandNode<CommandSource>, CommandSyntaxException>();
                }
                errors.put(child, ex);
                reader.setCursor(cursor);
                continue;
            }
            context.withCommand((Command<CommandSource>)child.getCommand());
            if (this.shouldContinueTraversing(reader, child)) {
                reader.skip();
                CommandNode redirect = child.getRedirect();
                if (redirect != null) {
                    SpongeCommandContextBuilder childContext = new SpongeCommandContextBuilder(this, source, (CommandNode<CommandSource>)child.getRedirect(), reader.getCursor());
                    context.applySpongeElementsTo(childContext, false);
                    ParseResults<CommandSource> parse = this.parseNodes(redirect instanceof RootCommandNode, isSuggestion, (CommandNode<CommandSource>)child.getRedirect(), reader, childContext);
                    childContext.applySpongeElementsTo(context, true);
                    context.withChild((CommandContextBuilder<CommandSource>)parse.getContext());
                    ParseResults parse2 = new ParseResults((CommandContextBuilder)context, parse.getReader(), parse.getExceptions());
                    if (doesNotRead && potentials != null) {
                        potentials.add(parse2);
                        continue;
                    }
                    return parse2;
                }
                ParseResults<CommandSource> parse = this.parseNodes(false, isSuggestion, child, reader, context);
                if (potentials == null) {
                    potentials = new ArrayList(1);
                }
                potentials.add(parse);
                continue;
            }
            if (potentials == null) {
                potentials = new ArrayList<ParseResults>(1);
            }
            potentials.add(new ParseResults((CommandContextBuilder)context, (ImmutableStringReader)reader, Collections.emptyMap()));
        }
        if (potentials != null) {
            if (potentials.size() > 1) {
                potentials.sort((a, b) -> {
                    if (!a.getReader().canRead() && b.getReader().canRead()) {
                        return -1;
                    }
                    if (a.getReader().canRead() && !b.getReader().canRead()) {
                        return 1;
                    }
                    if (a.getExceptions().isEmpty() && !b.getExceptions().isEmpty()) {
                        return -1;
                    }
                    if (!a.getExceptions().isEmpty() && b.getExceptions().isEmpty()) {
                        return 1;
                    }
                    Command<CommandSource> aCommand = SpongeCommandDispatcher.getCommand((CommandContextBuilder<CommandSource>)a.getContext());
                    Command<CommandSource> bCommand = SpongeCommandDispatcher.getCommand((CommandContextBuilder<CommandSource>)b.getContext());
                    if (aCommand == null && bCommand != null) {
                        return 1;
                    }
                    if (aCommand != null && bCommand == null) {
                        return -1;
                    }
                    return 0;
                });
            }
            return (ParseResults)potentials.get(0);
        }
        return new ParseResults((CommandContextBuilder)contextSoFar, (ImmutableStringReader)originalReader, errors == null ? Collections.emptyMap() : errors);
    }

    private static Command<CommandSource> getCommand(CommandContextBuilder<CommandSource> context) {
        Command command = context.getCommand();
        if (command == null && context.getChild() != null) {
            return SpongeCommandDispatcher.getCommand((CommandContextBuilder<CommandSource>)context.getChild());
        }
        return command;
    }

    public CompletableFuture<Suggestions> getCompletionSuggestions(ParseResults<CommandSource> parse, int cursor) {
        CommandContextBuilder context = parse.getContext();
        SuggestionContext nodeBeforeCursor = context.findSuggestionContext(cursor);
        CommandNode parent = nodeBeforeCursor.parent;
        int start = Math.min(nodeBeforeCursor.startPos, cursor);
        String fullInput = parse.getReader().getString();
        String truncatedInput = fullInput.substring(0, cursor);
        Collection<CommandNode<CommandSource>> children = parent instanceof SpongeNode ? ((SpongeNode)parent).getChildrenForSuggestions() : parent.getChildren();
        CompletableFuture[] futures = new CompletableFuture[children.size()];
        int i = 0;
        for (CommandNode<CommandSource> node : children) {
            CompletableFuture future = Suggestions.empty();
            try {
                future = node.listSuggestions(context.build(truncatedInput), new SuggestionsBuilder(truncatedInput, start));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            futures[i++] = future;
        }
        return CompletableFuture.allOf(futures).handle((voidResult, exception) -> {
            ArrayList suggestions = new ArrayList();
            for (CompletableFuture future : futures) {
                if (future.isCompletedExceptionally()) continue;
                suggestions.add(future.join());
            }
            return Suggestions.merge((String)fullInput, suggestions);
        });
    }

    public void findAmbiguities(AmbiguityConsumer<CommandSource> consumer) {
    }

    private boolean shouldContinueTraversing(SpongeStringReader reader, CommandNode<CommandSource> child) {
        CommandNode redirect = child.getRedirect();
        if (redirect == null) {
            return reader.canRead(2) || child.getChildren().stream().anyMatch(x -> x instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)x).getParser().doesNotRead());
        }
        return reader.canRead(1) || redirect.getChildren().stream().anyMatch(x -> x instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)x).getParser().doesNotRead());
    }

    CommandManager getCommandManager() {
        return this.commandManager;
    }
}

