/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.tree;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minecraft.command.CommandSource;
import org.spongepowered.api.command.CommandExecutor;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContext;
import org.spongepowered.common.command.exception.SpongeCommandSyntaxException;

public final class SpongeCommandExecutorWrapper
implements Command<CommandSource> {
    private final CommandExecutor executor;

    public SpongeCommandExecutorWrapper(CommandExecutor executor) {
        this.executor = executor;
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        SpongeCommandContext spongeCommandContext = (SpongeCommandContext)context;
        try {
            CommandResult result = Objects.requireNonNull(this.executor.execute(spongeCommandContext), "A CommandResult was expected, but the command returned null instead. Report this to the plugin author!");
            if (!result.isSuccess()) {
                Component errorMessage = result.getErrorMessage().orElse(Component.text((String)"An unknown error occurred while executing the command ").append((Component)Component.text((String)context.getInput())));
                throw new SpongeCommandSyntaxException(new CommandException(errorMessage), spongeCommandContext);
            }
            return result.getResult();
        }
        catch (CommandException e) {
            throw new SpongeCommandSyntaxException(e, spongeCommandContext);
        }
    }
}

