/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.manager;

import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.util.Nameable;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.command.CommandSourceBridge;
import org.spongepowered.common.bridge.command.CommandSourceProviderBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.VecHelper;

public final class SpongeCommandCauseFactory
implements CommandCause.Factory {
    @Override
    public @NonNull CommandCause create() {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            CommandSource commandSource;
            Cause cause = frame.getCurrentCause();
            ICommandSource iCommandSource = cause.first(ICommandSource.class).orElseGet(() -> SpongeCommon.getGame().getSystemSubject());
            if (iCommandSource instanceof CommandSourceProviderBridge) {
                commandSource = ((CommandSourceProviderBridge)iCommandSource).bridge$getCommandSource(cause);
            } else {
                Locatable locatable;
                EventContext context = cause.getContext();
                Locatable locatable2 = locatable = iCommandSource instanceof Locatable ? (Locatable)iCommandSource : null;
                Object displayName = iCommandSource instanceof org.spongepowered.api.entity.Entity ? ((org.spongepowered.api.entity.Entity)iCommandSource).get(Keys.DISPLAY_NAME).map(SpongeAdventure::asVanilla).orElseGet(() -> new StringTextComponent(iCommandSource instanceof Nameable ? ((Nameable)iCommandSource).getName() : iCommandSource.getClass().getSimpleName())) : new StringTextComponent(iCommandSource instanceof Nameable ? ((Nameable)iCommandSource).getName() : iCommandSource.getClass().getSimpleName());
                String name = displayName.getString();
                commandSource = new CommandSource(iCommandSource, context.get(EventContextKeys.LOCATION).map(x -> VecHelper.toVanillaVector3d(x.getPosition())).orElseGet(() -> locatable == null ? Vector3d.field_186680_a : VecHelper.toVanillaVector3d(locatable.getLocation().getPosition())), context.get(EventContextKeys.ROTATION).map(x -> new Vector2f((float)x.getX(), (float)x.getY())).orElse(Vector2f.field_189974_a), context.get(EventContextKeys.LOCATION).map(x -> (ServerWorld)x.getWorld()).orElseGet(() -> locatable == null ? SpongeCommon.getServer().func_71218_a(World.field_234918_g_) : (ServerWorld)locatable.getServerLocation().getWorld()), 4, name, (ITextComponent)displayName, SpongeCommon.getServer(), iCommandSource instanceof org.spongepowered.api.entity.Entity ? (Entity)iCommandSource : null);
            }
            ((CommandSourceBridge)commandSource).bridge$setCause(frame.getCurrentCause());
            CommandCause commandCause = (CommandCause)commandSource;
            return commandCause;
        }
    }
}

