/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.manager;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.util.ComponentMessageThrowable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandFailedRegistrationException;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.api.command.registrar.CommandRegistrarType;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.command.ExecuteCommandEvent;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.command.CommandsBridge;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;
import org.spongepowered.common.command.exception.SpongeCommandSyntaxException;
import org.spongepowered.common.command.manager.SpongeCommandMapping;
import org.spongepowered.common.command.registrar.BrigadierCommandRegistrar;
import org.spongepowered.common.command.registrar.SpongeParameterizedCommandRegistrar;
import org.spongepowered.common.command.registrar.tree.builder.RootCommandTreeNode;
import org.spongepowered.common.command.sponge.SpongeCommand;
import org.spongepowered.common.event.lifecycle.RegisterCommandEventImpl;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.service.game.pagination.SpongePaginationService;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeCommandManager
implements CommandManager.Mutable {
    private static final boolean ALWAYS_PRINT_STACKTRACES = System.getProperty("sponge.command.alwaysPrintStacktraces") != null;
    private final Game game;
    private final Provider<SpongeCommand> spongeCommand;
    private final Map<String, SpongeCommandMapping> commandMappings = new HashMap<String, SpongeCommandMapping>();
    private final Multimap<SpongeCommandMapping, String> inverseCommandMappings = HashMultimap.create();
    private final Multimap<PluginContainer, SpongeCommandMapping> pluginToCommandMap = HashMultimap.create();
    private final LinkedHashMap<SpongeCommandMapping, RootCommandTreeNode> mappingToSuggestionNodes = new LinkedHashMap();
    private final Map<Class<?>, CommandRegistrar<?>> knownRegistrars = new ConcurrentHashMap();
    private BrigadierCommandRegistrar brigadierRegistrar;

    public static SpongeCommandManager get(MinecraftServer server) {
        return ((CommandsBridge)server.func_195571_aL()).bridge$commandManager();
    }

    @Inject
    public SpongeCommandManager(Game game, Provider<SpongeCommand> spongeCommand) {
        this.game = game;
        this.spongeCommand = spongeCommand;
    }

    public SpongeCommandDispatcher getDispatcher() {
        return this.brigadierRegistrar.getDispatcher();
    }

    public BrigadierCommandRegistrar getBrigadierRegistrar() {
        return this.brigadierRegistrar;
    }

    @Override
    public @NonNull Set<String> getKnownAliases() {
        return ImmutableSet.copyOf(this.commandMappings.keySet());
    }

    public @NonNull CommandMapping registerNamespacedAlias(@NonNull CommandRegistrar<?> registrar, @NonNull PluginContainer container, @NonNull LiteralCommandNode<CommandSource> rootArgument, String ... secondaryAliases) throws CommandFailedRegistrationException {
        String namespaced = rootArgument.getLiteral();
        String notnamespaced = namespaced.split(":")[1];
        ArrayList<String> otherAliases = new ArrayList<String>();
        otherAliases.add(notnamespaced);
        otherAliases.addAll(Arrays.asList(secondaryAliases));
        return this.registerAliasWithNamespacing(registrar, container, namespaced, otherAliases, null);
    }

    @Override
    public @NonNull CommandMapping registerAlias(@NonNull CommandRegistrar<?> registrar, @NonNull PluginContainer container,  @NonNull CommandTreeNode.Root parameterTree, @NonNull String primaryAlias, String ... secondaryAliases) throws CommandFailedRegistrationException {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(primaryAlias);
        Collections.addAll(aliases, secondaryAliases);
        String namespaced = container.getMetadata().getId() + ":" + primaryAlias.toLowerCase(Locale.ROOT);
        return this.registerAliasWithNamespacing(registrar, container, namespaced, aliases, parameterTree);
    }

    public @NonNull CommandMapping registerAliasWithNamespacing(@NonNull CommandRegistrar<?> registrar, @NonNull PluginContainer container, @NonNull String namespacedAlias, @NonNull Collection<String> otherAliases,  @Nullable CommandTreeNode.Root parameterTree) throws CommandFailedRegistrationException {
        if (namespacedAlias.contains(" ") || otherAliases.stream().anyMatch(x -> x.contains(" ") || x.contains(":"))) {
            throw new CommandFailedRegistrationException("Aliases may not contain spaces or colons.");
        }
        if (!this.knownRegistrars.containsKey(GenericTypeReflector.erase(registrar.type().handledType().getType()))) {
            throw new IllegalArgumentException(String.format("Plugin '%s' is trying to register command %s with unknown registrar %s", container.getMetadata().getId(), namespacedAlias, registrar));
        }
        if (this.commandMappings.containsKey(namespacedAlias)) {
            throw new CommandFailedRegistrationException("The command alias " + namespacedAlias + " has already been registered for this plugin");
        }
        HashSet<String> aliases = new HashSet<String>();
        aliases.add(namespacedAlias);
        for (String secondaryAlias : otherAliases) {
            aliases.add(secondaryAlias.toLowerCase(Locale.ROOT));
        }
        aliases.removeIf(this.commandMappings::containsKey);
        SpongeConfigs.getCommon().get().commands.aliases.entrySet().stream().filter(x -> !((String)x.getValue()).equalsIgnoreCase(container.getMetadata().getId())).filter(x -> aliases.contains(x.getKey())).forEach(x -> aliases.remove(x.getKey()));
        if (aliases.isEmpty()) {
            throw new CommandFailedRegistrationException("No aliases could be registered for the supplied command.");
        }
        SpongeCommandMapping mapping = new SpongeCommandMapping(namespacedAlias, aliases, container, registrar);
        this.pluginToCommandMap.put((Object)container, (Object)mapping);
        aliases.forEach(key -> {
            this.commandMappings.put((String)key, mapping);
            this.inverseCommandMappings.put((Object)mapping, key);
        });
        if (parameterTree instanceof RootCommandTreeNode) {
            this.mappingToSuggestionNodes.put(mapping, (RootCommandTreeNode)parameterTree);
        }
        return mapping;
    }

    @Override
    public @NonNull Collection<PluginContainer> getPlugins() {
        return ImmutableSet.copyOf((Collection)this.pluginToCommandMap.keySet());
    }

    @Override
    public @NonNull Optional<CommandMapping> getCommandMapping(String alias) {
        return Optional.ofNullable(this.commandMappings.get(alias.toLowerCase()));
    }

    @Override
    public void updateCommandTreeForPlayer(@NonNull ServerPlayer player) {
        Objects.requireNonNull(player, "player");
        SpongeCommon.getServer().func_195571_aL().func_197051_a((ServerPlayerEntity)player);
    }

    @Override
    public <T> @NonNull Optional<CommandRegistrar<T>> registrar(@NonNull Class<T> type) {
        Objects.requireNonNull(type, "type");
        return Optional.ofNullable(this.knownRegistrars.get(type));
    }

    @Override
    public <T> @NonNull Optional<CommandRegistrar<T>> registrar(@NonNull TypeToken<T> type) {
        Objects.requireNonNull(type, "type");
        return this.registrar(GenericTypeReflector.erase(type.getType()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @NonNull CommandResult process(@NonNull String arguments) throws CommandException {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.COMMAND, arguments);
            CommandResult commandResult = this.process(CommandCause.create(), arguments);
            return commandResult;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new CommandException((Component)Component.text((String)commandSyntaxException.getMessage()), (Throwable)commandSyntaxException);
        }
    }

    public CommandResult process(CommandCause cause, String arguments) throws CommandException, CommandSyntaxException {
        CommandResult result;
        String[] splitArg = arguments.split(" ", 2);
        String originalCommand = splitArg[0];
        String originalArgs = splitArg.length == 2 ? splitArg[1] : "";
        ExecuteCommandEvent.Pre preEvent = SpongeEventFactory.createExecuteCommandEventPre(cause.getCause(), originalArgs, originalArgs, originalCommand, originalCommand, cause, Optional.empty(), false);
        if (this.game.getEventManager().post(preEvent)) {
            return preEvent.getResult().orElse(CommandResult.empty());
        }
        String command = preEvent.getCommand();
        String args = preEvent.getArguments();
        SpongeCommandMapping mapping = this.commandMappings.get(command.toLowerCase());
        if (mapping == null) {
            throw new CommandException((Component)Component.text((String)"Unknown command. Type /help for a list of commands."));
        }
        try {
            result = mapping.getRegistrar().process(cause, mapping, command, args);
        }
        catch (CommandException exception) {
            CommandResult errorResult = CommandResult.builder().setResult(0).error(exception.componentMessage()).build();
            this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, errorResult);
            if (ALWAYS_PRINT_STACKTRACES) {
                this.prettyPrintThrowableError(exception, command, args, cause);
            }
            throw exception;
        }
        catch (net.minecraft.command.CommandException ex) {
            CommandResult errorResult = CommandResult.builder().setResult(0).error(SpongeAdventure.asAdventure(ex.func_197003_a())).build();
            this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, errorResult);
            if (ALWAYS_PRINT_STACKTRACES) {
                this.prettyPrintThrowableError(ex, command, args, cause);
            }
            throw ex;
        }
        catch (Throwable thr) {
            Component text;
            this.prettyPrintThrowableError(thr, command, args, cause);
            Object excBuilder = thr instanceof ComponentMessageThrowable ? ((text = ((ComponentMessageThrowable)thr).componentMessage()) == null ? Component.text((String)"null") : text) : Component.text((String)String.valueOf(thr.getMessage()));
            if (cause.hasPermission("sponge.debug.hover-stacktrace")) {
                StringWriter writer = new StringWriter();
                thr.printStackTrace(new PrintWriter(writer));
                excBuilder = excBuilder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)writer.toString().replace("\t", "    ").replace("\r\n", "\n").replace("\r", "\n"))));
            }
            BuildableComponent error = ((TextComponent.Builder)Component.text().content("Unexpected error occurred while executing command: ").append((Component)excBuilder)).build();
            this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, CommandResult.error((Component)error));
            throw new CommandException((Component)error, thr);
        }
        this.postExecuteCommandPostEvent(cause, originalArgs, args, originalCommand, command, result);
        result.getErrorMessage().ifPresent(x -> cause.sendMessage(Identity.nil(), (Component)x));
        return result;
    }

    @Override
    public <T extends Subject & Audience> @NonNull CommandResult process(@NonNull T subjectReceiver, @NonNull String arguments) throws CommandException {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT, subjectReceiver);
            frame.addContext(EventContextKeys.AUDIENCE, subjectReceiver);
            CommandResult commandResult = this.process(arguments);
            return commandResult;
        }
    }

    @Override
    public @NonNull CommandResult process(@NonNull Subject subject, @NonNull Audience receiver, @NonNull String arguments) throws CommandException {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT, subject);
            frame.addContext(EventContextKeys.AUDIENCE, receiver);
            CommandResult commandResult = this.process(arguments);
            return commandResult;
        }
    }

    private void postExecuteCommandPostEvent(CommandCause cause, String originalArgs, String args, String originalCommand, String command, CommandResult result) {
        this.game.getEventManager().post(SpongeEventFactory.createExecuteCommandEventPost(cause.getCause(), originalArgs, args, originalCommand, command, cause, result));
    }

    private void prettyPrintThrowableError(Throwable thr, String commandNoArgs, String args, CommandCause cause) {
        String commandString = args != null && !args.isEmpty() ? commandNoArgs + " " + args : commandNoArgs;
        SpongeCommandMapping mapping = this.commandMappings.get(commandNoArgs.toLowerCase());
        PrettyPrinter prettyPrinter = new PrettyPrinter(100).add("Unexpected error occurred while executing command '%s'", commandString).centre().hr().addWrapped("While trying to run '%s', an error occurred that the command processor was not expecting. This usually indicates an error in the plugin that owns this command. Report this error to the plugin developer first - this is usually not a Sponge error.", commandString).hr().add().add("Command: %s", commandString).add("Owning Plugin: %s", mapping.getPlugin().getMetadata().getId()).add("Owning Registrar: %s", mapping.getRegistrar().getClass().getName()).add().add("Exception Details: ");
        if (thr instanceof SpongeCommandSyntaxException) {
            prettyPrinter.add(thr.getCause());
        } else {
            prettyPrinter.add(thr);
        }
        prettyPrinter.add().add("CommandCause details: ").addWrapped(cause.getCause().toString(), new Object[0]).log(SpongeCommon.getLogger(), Level.ERROR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @NonNull List<String> suggest(@NonNull String arguments) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.COMMAND, arguments);
            String[] splitArg = arguments.split(" ", 2);
            String command = splitArg[0].toLowerCase();
            if (splitArg.length == 2) {
                SpongeCommandMapping mapping = this.commandMappings.get(command);
                if (mapping == null) {
                    List<String> list = Collections.emptyList();
                    return list;
                }
                List<String> list = mapping.getRegistrar().suggestions(CommandCause.create(), mapping, command, splitArg[1]);
                return list;
            }
            List<String> list = this.commandMappings.keySet().stream().filter(x -> x.startsWith(command)).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Override
    public <T extends Subject & Audience> @NonNull List<String> suggest(@NonNull T subjectReceiver, @NonNull String arguments) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT, subjectReceiver);
            frame.addContext(EventContextKeys.AUDIENCE, subjectReceiver);
            List<String> list = this.suggest(arguments);
            return list;
        }
    }

    @Override
    public @NonNull List<String> suggest(@NonNull Subject subject, @NonNull Audience receiver, @NonNull String arguments) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SUBJECT, subject);
            frame.addContext(EventContextKeys.AUDIENCE, receiver);
            List<String> list = this.suggest(arguments);
            return list;
        }
    }

    public void init() {
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        HashSet usedTokens = new HashSet();
        Sponge.getGame().registries().registry(RegistryTypes.COMMAND_REGISTRAR_TYPE).streamEntries().forEach(entry -> {
            CommandRegistrarType type = (CommandRegistrarType)entry.value();
            TypeToken handledType = type.handledType();
            if (handledType == null) {
                SpongeCommon.getLogger().error("Registrar '{}' did not provide a handledType, skipping...", (Object)type.getClass());
            } else if (usedTokens.add(handledType)) {
                CommandRegistrar registrar = type.create(this);
                this.knownRegistrars.put(GenericTypeReflector.erase(type.handledType().getType()), registrar);
                if (registrar instanceof BrigadierCommandRegistrar) {
                    this.brigadierRegistrar = (BrigadierCommandRegistrar)registrar;
                } else if (registrar instanceof SpongeParameterizedCommandRegistrar) {
                    this.registerInternalCommands((SpongeParameterizedCommandRegistrar)registrar);
                }
                this.game.getEventManager().post(this.createEvent(cause, this.game, registrar));
            } else {
                SpongeCommon.getLogger().warn("Command type '{}' has already been collected, skipping request from {}", (Object)handledType.toString(), (Object)type.getClass());
            }
        });
        if (this.brigadierRegistrar == null) {
            throw new IllegalStateException("Brigadier registrar was not detected");
        }
    }

    private void registerInternalCommands(CommandRegistrar<Command.Parameterized> registrar) {
        try {
            registrar.register(((Launch)Launch.getInstance()).getCommonPlugin(), ((SpongeCommand)this.spongeCommand.get()).createSpongeCommand(), "sponge", new String[0]);
        }
        catch (CommandFailedRegistrationException ex) {
            throw new RuntimeException("Failed to create root Sponge command!", ex);
        }
        try {
            PaginationService paginationService = Sponge.getServiceProvider().paginationService();
            if (paginationService instanceof SpongePaginationService) {
                registrar.register(((Launch)Launch.getInstance()).getCommonPlugin(), ((SpongePaginationService)paginationService).createPaginationCommand(), "pagination", "page");
            }
        }
        catch (CommandFailedRegistrationException ex) {
            throw new RuntimeException("Failed to create pagination command!", ex);
        }
        registrar.register(((Launch)Launch.getInstance()).getCommonPlugin(), SpongeAdventure.CALLBACK_COMMAND.createCommand(), "callback", new String[0]);
    }

    public Collection<CommandNode<ISuggestionProvider>> getNonBrigadierSuggestions(CommandCause cause) {
        ArrayList<CommandNode<ISuggestionProvider>> suggestions = new ArrayList<CommandNode<ISuggestionProvider>>();
        for (Map.Entry<SpongeCommandMapping, RootCommandTreeNode> entry : this.mappingToSuggestionNodes.entrySet()) {
            SpongeCommandMapping mapping = entry.getKey();
            CommandNode node = entry.getValue().createArgumentTree(cause, (LiteralArgumentBuilder<ISuggestionProvider>)LiteralArgumentBuilder.literal((String)mapping.getPrimaryAlias()));
            if (node == null) continue;
            Command executableCommand = node.getCommand();
            CommandNode toRedirectTo = node.getRedirect() == null ? node : node.getRedirect();
            suggestions.add((CommandNode<ISuggestionProvider>)node);
            for (String alias : mapping.getAllAliases()) {
                if (alias.equals(mapping.getPrimaryAlias())) continue;
                suggestions.add((CommandNode<ISuggestionProvider>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).executes(executableCommand)).redirect(toRedirectTo)).build());
            }
        }
        return suggestions;
    }

    public Collection<String> getAliasesThatStartWithForCause(CommandCause cause, String startingText) {
        String toCompare = startingText.toLowerCase(Locale.ROOT);
        ArrayList<String> aliases = new ArrayList<String>();
        Object2BooleanOpenHashMap testedMappings = new Object2BooleanOpenHashMap();
        for (Map.Entry<String, SpongeCommandMapping> mappingEntry : this.commandMappings.entrySet()) {
            if (!mappingEntry.getKey().startsWith(toCompare) || !testedMappings.computeBooleanIfAbsent((Object)mappingEntry.getValue(), mapping -> mapping.getRegistrar().canExecute(cause, (CommandMapping)mapping))) continue;
            aliases.add(toCompare);
        }
        return aliases;
    }

    public Collection<String> getAliasesForCause(CommandCause cause) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (SpongeCommandMapping mapping : this.inverseCommandMappings.keySet()) {
            if (!mapping.getRegistrar().canExecute(cause, mapping)) continue;
            aliases.addAll(this.inverseCommandMappings.get((Object)mapping));
        }
        return aliases;
    }

    private <C, R extends CommandRegistrar<C>> RegisterCommandEventImpl<C, R> createEvent(Cause cause, Game game, R registrar) {
        return new RegisterCommandEventImpl(cause, game, registrar);
    }
}

