/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.command.CommandException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.api.command.parameter.managed.ValueParser;
import org.spongepowered.api.command.parameter.managed.ValueUsage;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;

public final class SpongeParameterValue<T>
implements Parameter.Value<T> {
    private final ImmutableList<ValueParser<? extends T>> parsers;
    private final ValueCompleter completer;
    private final Predicate<CommandCause> requirement;
    private final @Nullable ValueUsage usage;
    private final Parameter.Key<T> key;
    private final boolean isOptional;
    private final boolean consumeAll;
    private final boolean terminal;

    public SpongeParameterValue(ImmutableList<ValueParser<? extends T>> parsers, ValueCompleter completer, @Nullable ValueUsage usage, Predicate<CommandCause> requirement, Parameter.Key<T> key, boolean isOptional, boolean consumeAll, boolean terminal) {
        this.parsers = parsers;
        this.completer = completer;
        this.requirement = requirement;
        this.usage = usage;
        this.key = key;
        this.isOptional = isOptional;
        this.consumeAll = consumeAll;
        this.terminal = consumeAll || terminal;
    }

    @Override
    public void parse( @NonNull ArgumentReader.Mutable args, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        ArgumentReader.Immutable readerState = args.getImmutable();
        CommandContext.Builder.Transaction transaction = context.startTransaction();
        try {
            do {
                args.skipWhitespace();
                this.parseInternal(args, context);
            } while (this.consumeAll && args.canRead());
        }
        catch (ArgumentParseException apex) {
            args.setState(readerState);
            context.rollback(transaction);
            if (!this.isOptional) {
                return;
            }
            throw apex;
        }
        context.commit(transaction);
    }

    private void parseInternal(ArgumentReader.Mutable args, CommandContext.Builder context) throws ArgumentParseException {
        ArrayList<ArgumentParseException> currentExceptions = null;
        ArgumentReader.Immutable state = args.getImmutable();
        CommandContext.Builder.Transaction transaction = context.startTransaction();
        for (ValueParser parser : this.parsers) {
            try {
                parser.getValue(this.key, args, context).ifPresent(t -> context.putEntry(this.key, t));
                context.commit(transaction);
                return;
            }
            catch (ArgumentParseException ex) {
                if (currentExceptions == null) {
                    currentExceptions = new ArrayList<ArgumentParseException>();
                }
                currentExceptions.add(ex);
                args.setState(state);
                context.rollback(transaction);
            }
        }
        if (currentExceptions == null) {
            throw new CommandException((ITextComponent)new StringTextComponent("Could not parse element"));
        }
        if (currentExceptions.size() == 1) {
            throw (ArgumentParseException)currentExceptions.get(0);
        }
        List errors = currentExceptions.stream().map(ArgumentParseException::getSuperText).collect(Collectors.toList());
        throw new ArgumentParseException((Component)Component.join((ComponentLike)Component.newline(), errors), args.getInput(), args.getCursor());
    }

    @Override
    public  @NonNull Parameter.Key<T> getKey() {
        return this.key;
    }

    @Override
    public @NonNull List<String> complete( @NonNull ArgumentReader.Immutable reader, @NonNull CommandContext context) {
        return this.completer.complete(context, reader.getRemaining());
    }

    @Override
    public @NonNull String getUsage(@NonNull CommandCause cause) {
        if (this.usage != null) {
            return this.usage.getUsage(this.key.key());
        }
        String usage = this.key.key();
        if (this.isOptional) {
            return "[" + usage + "]";
        }
        return usage;
    }

    @Override
    public @NonNull Collection<ValueParser<? extends T>> getParsers() {
        return this.parsers;
    }

    @Override
    public @NonNull ValueCompleter getCompleter() {
        return this.completer;
    }

    @Override
    public Optional<ValueUsage> getValueUsage() {
        return Optional.ofNullable(this.usage);
    }

    @Override
    public @NonNull Predicate<CommandCause> getRequirement() {
        return this.requirement;
    }

    @Override
    public boolean isTerminal() {
        return this.terminal;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean willConsumeAllRemaining() {
        return this.consumeAll;
    }

    public @Nullable ArgumentParser<? extends T> getArgumentTypeIfStandard() {
        ValueParser parser;
        if (this.parsers.size() == 1 && (parser = (ValueParser)this.parsers.get(0)) instanceof ArgumentParser) {
            return (ArgumentParser)((Object)parser);
        }
        return null;
    }
}

