/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.mojang.brigadier.arguments.ArgumentType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.common.command.brigadier.argument.AbstractArgumentParser;
import org.spongepowered.common.util.Constants;

public final class SpongeCatalogedElementValueParameter<T>
extends AbstractArgumentParser<T> {
    private final List<String> prefixes;
    private final Function<CommandContext, @Nullable ? extends Registry<? extends T>> registryFunction;

    public SpongeCatalogedElementValueParameter(List<String> prefixes, Function<CommandContext, @Nullable ? extends Registry<? extends T>> registryFunction) {
        this.prefixes = prefixes;
        this.registryFunction = registryFunction;
    }

    @Override
    public @NonNull Optional<? extends T> getValue( @NonNull Parameter.Key<? super T> parameterKey,  @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        Registry<T> registry = this.registryFunction.apply(context);
        if (registry == null) {
            throw reader.createException((Component)Component.text((String)"The registry associated with this parameter is not currently active."));
        }
        ArgumentReader.Immutable snapshot = reader.getImmutable();
        try {
            ResourceKey resourceKey = reader.parseResourceKey();
            Optional result = registry.findValue(resourceKey);
            if (!result.isPresent()) {
                throw reader.createException((Component)Component.text((String)("Registry " + registry.type().location().asString() + " does not contain the ID " + resourceKey.asString())));
            }
            return result;
        }
        catch (ArgumentParseException ex) {
            if (this.prefixes.isEmpty()) {
                throw ex;
            }
            reader.setState(snapshot);
            String check = reader.parseUnquotedString();
            for (String prefix : this.prefixes) {
                Optional result = registry.findValue(ResourceKey.of(prefix, check));
                if (!result.isPresent()) continue;
                return result;
            }
            String ids = this.prefixes.stream().map(x -> x + ":" + check).collect(Collectors.joining(", "));
            throw reader.createException((Component)Component.text((String)("Registry " + registry.type().location().asString() + " does not contain any of the following IDs: " + ids)));
        }
    }

    @Override
    public @NonNull List<String> complete(@NonNull CommandContext context, @NonNull String currentInput) {
        Registry<T> registry = this.registryFunction.apply(context);
        if (registry == null) {
            return Collections.emptyList();
        }
        String lowerCase = currentInput.toLowerCase();
        return registry.streamEntries().map(RegistryEntry::key).map(x -> {
            if (x.asString().startsWith(lowerCase)) {
                return x.asString();
            }
            if (this.prefixes.contains(x.getNamespace()) && x.getValue().startsWith(lowerCase)) {
                return x.getValue();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return Collections.singletonList(Constants.Command.RESOURCE_LOCATION_TYPE);
    }
}

