/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedArgumentValueParser;

public final class SpongeDurationValueParameter
extends ResourceKeyedArgumentValueParser<Duration> {
    public SpongeDurationValueParameter(ResourceKey key) {
        super(key);
    }

    @Override
    public @NonNull List<String> complete(@NonNull CommandContext context, String currentInput) {
        return ImmutableList.of();
    }

    @Override
    public @NonNull Optional<? extends Duration> getValue( @NonNull Parameter.Key<? super Duration> parameterKey,  @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        String s2 = reader.parseString().toUpperCase();
        if (!s2.contains("T")) {
            if (s2.contains("D")) {
                if (s2.contains("H") || s2.contains("M") || s2.contains("S")) {
                    s2 = s2.replace("D", "DT");
                }
            } else {
                s2 = s2.startsWith("P") ? "PT" + s2.substring(1) : "T" + s2;
            }
        }
        if (!s2.startsWith("P")) {
            s2 = "P" + s2;
        }
        try {
            return Optional.of(Duration.parse(s2));
        }
        catch (DateTimeParseException ex) {
            throw reader.createException((Component)Component.text((String)"Invalid duration!"));
        }
    }
}

