/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.registrar;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.leangen.geantyref.TypeToken;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandFailedRegistrationException;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.api.command.registrar.CommandRegistrarType;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;
import org.spongepowered.common.command.brigadier.tree.SpongeLiteralCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongePermissionWrappedLiteralCommandNode;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.BrigadierBasedRegistrar;
import org.spongepowered.common.command.registrar.SpongeCommandRegistrarType;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.plugin.PluginContainer;

public final class BrigadierCommandRegistrar
implements BrigadierBasedRegistrar,
CommandRegistrar<LiteralArgumentBuilder<CommandSource>> {
    public static final CommandRegistrarType<LiteralArgumentBuilder<CommandSource>> TYPE = new SpongeCommandRegistrarType<LiteralArgumentBuilder<CommandSource>>(new TypeToken<LiteralArgumentBuilder<CommandSource>>(){}, BrigadierCommandRegistrar::new);
    private final SpongeCommandManager manager;
    private SpongeCommandDispatcher dispatcher;

    public BrigadierCommandRegistrar(CommandManager.Mutable manager) {
        this.manager = (SpongeCommandManager)manager;
        this.dispatcher = new SpongeCommandDispatcher(this.manager);
    }

    public LiteralCommandNode<CommandSource> register(LiteralArgumentBuilder<CommandSource> command) {
        PluginContainer container = PhaseTracker.getCauseStackManager().getCurrentCause().first(PluginContainer.class).orElseThrow(() -> new IllegalStateException("Cannot register command without knowing its origin."));
        return this.registerInternal(this, container, this.applyNamespace(container, command, false), new String[0], true).getSecond();
    }

    @Override
    public @NonNull CommandRegistrarType<LiteralArgumentBuilder<CommandSource>> type() {
        return TYPE;
    }

    @Override
    public @NonNull CommandMapping register(@NonNull PluginContainer container, @NonNull LiteralArgumentBuilder<CommandSource> command, @NonNull String primaryAlias, String ... secondaryAliases) throws CommandFailedRegistrationException {
        return this.register(container, command, secondaryAliases).getFirst();
    }

    public Tuple<CommandMapping, LiteralCommandNode<CommandSource>> register(PluginContainer container, LiteralArgumentBuilder<CommandSource> command, String ... secondaryAliases) {
        return this.registerInternal(this, container, this.applyNamespace(container, command, true), secondaryAliases, false);
    }

    private Tuple<CommandMapping, LiteralCommandNode<CommandSource>> registerInternal(CommandRegistrar<?> registrar, PluginContainer container, LiteralCommandNode<CommandSource> namespacedCommand, String[] secondaryAliases, boolean allowDuplicates) {
        String requestedAlias = namespacedCommand.getLiteral();
        Optional<CommandMapping> existingMapping = this.manager.getCommandMapping(requestedAlias);
        if (allowDuplicates && existingMapping.isPresent()) {
            this.dispatcher.register(namespacedCommand);
            return Tuple.of(existingMapping.get(), namespacedCommand);
        }
        CommandMapping mapping = this.manager.registerNamespacedAlias(registrar, container, namespacedCommand, secondaryAliases);
        this.dispatcher.register(namespacedCommand);
        for (String alias : mapping.getAllAliases()) {
            if (alias.equals(namespacedCommand.getLiteral())) continue;
            LiteralArgumentBuilder redirecting = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).executes(namespacedCommand.getCommand())).requires(namespacedCommand.getRequirement());
            if (namespacedCommand.getRedirect() == null) {
                redirecting.redirect(namespacedCommand);
            } else {
                redirecting.forward(namespacedCommand.getRedirect(), namespacedCommand.getRedirectModifier(), namespacedCommand.isFork());
            }
            this.dispatcher.register((LiteralCommandNode<CommandSource>)redirecting.build());
        }
        return Tuple.of(mapping, namespacedCommand);
    }

    @Override
    public @NonNull CommandResult process(@NonNull CommandCause cause, @NonNull CommandMapping mapping, @NonNull String command, @NonNull String arguments) throws CommandException {
        try {
            int result = this.dispatcher.execute(this.dispatcher.parse(this.createCommandString(command, arguments), (CommandSource)cause));
            return CommandResult.builder().setResult(result).build();
        }
        catch (CommandSyntaxException e) {
            throw new CommandException((Component)Component.text((String)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public @NonNull List<String> suggestions(@NonNull CommandCause cause, @NonNull CommandMapping mapping, @NonNull String command, @NonNull String arguments) {
        CompletableFuture suggestionsCompletableFuture = this.dispatcher.getCompletionSuggestions(this.dispatcher.parse(this.createCommandString(command, arguments), (CommandSource)cause, true));
        return ((Suggestions)suggestionsCompletableFuture.join()).getList().stream().map(Suggestion::getText).collect(Collectors.toList());
    }

    @Override
    public @NonNull Optional<Component> help(@NonNull CommandCause cause, @NonNull CommandMapping mapping) {
        CommandNode node = this.dispatcher.findNode(Collections.singletonList(mapping.getPrimaryAlias()));
        if (node != null) {
            return Optional.of(Component.text((String)this.dispatcher.getSmartUsage(node, (CommandSource)cause).toString()));
        }
        return Optional.empty();
    }

    @Override
    public boolean canExecute(CommandCause cause, CommandMapping mapping) {
        return this.dispatcher.findNode(Collections.singletonList(mapping.getPrimaryAlias())).getRequirement().test((CommandSource)cause);
    }

    public SpongeCommandDispatcher getDispatcher() {
        return this.dispatcher;
    }

    private String createCommandString(String command, String argument) {
        if (argument.isEmpty()) {
            return command;
        }
        return command + " " + argument;
    }

    private LiteralCommandNode<CommandSource> applyNamespace(PluginContainer pluginContainer, LiteralArgumentBuilder<CommandSource> builder, boolean isSpongeAware) {
        if (builder.getLiteral().contains(":") || builder.getLiteral().contains(" ")) {
            throw new IllegalArgumentException("The literal must not contain a colon or a space.");
        }
        LiteralArgumentBuilder replacementBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)(pluginContainer.getMetadata().getId() + ":" + builder.getLiteral())).forward(builder.getRedirect(), builder.getRedirectModifier(), builder.isFork())).executes(builder.getCommand())).requires(builder.getRequirement());
        for (CommandNode node : builder.getArguments()) {
            replacementBuilder.then(node);
        }
        if (isSpongeAware) {
            return new SpongeLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)replacementBuilder);
        }
        return new SpongePermissionWrappedLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)replacementBuilder);
    }
}

