/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.registrar.tree.key;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import java.util.function.BiFunction;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.command.arguments.serializers.DoubleArgumentSerializer;
import net.minecraft.command.arguments.serializers.FloatArgumentSerializer;
import net.minecraft.command.arguments.serializers.IntArgumentSerializer;
import net.minecraft.command.arguments.serializers.LongArgumentSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.registrar.tree.ClientCompletionKey;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;
import org.spongepowered.common.AbstractResourceKeyed;
import org.spongepowered.common.command.registrar.tree.builder.RangeCommandTreeNode;

public final class SpongeRangeClientCompletionKey<N extends Number>
extends AbstractResourceKeyed
implements ClientCompletionKey<CommandTreeNode.Range<N>> {
    private final BiFunction<N, N, ArgumentType<?>> typeCreator;
    private final N min;
    private final N max;

    public static @Nullable SpongeRangeClientCompletionKey<?> createFrom(ResourceKey key, IArgumentSerializer<?> serializer) {
        if (serializer instanceof FloatArgumentSerializer) {
            return new SpongeRangeClientCompletionKey<Float>(key, FloatArgumentType::floatArg, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        }
        if (serializer instanceof DoubleArgumentSerializer) {
            return new SpongeRangeClientCompletionKey<Double>(key, DoubleArgumentType::doubleArg, (Double)Double.MIN_VALUE, (Double)Double.MAX_VALUE);
        }
        if (serializer instanceof IntArgumentSerializer) {
            return new SpongeRangeClientCompletionKey<Integer>(key, IntegerArgumentType::integer, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (serializer instanceof LongArgumentSerializer) {
            return new SpongeRangeClientCompletionKey<Long>(key, LongArgumentType::longArg, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        return null;
    }

    private SpongeRangeClientCompletionKey(ResourceKey key, BiFunction<N, N, ArgumentType<?>> typeCreator, N min2, N max) {
        super(key);
        this.typeCreator = typeCreator;
        this.min = min2;
        this.max = max;
    }

    @Override
    public  @NonNull CommandTreeNode.Range<@NonNull N> createNode() {
        return new RangeCommandTreeNode<N>(this, this.typeCreator, this.min, this.max);
    }
}

