/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.inject.Inject;
import org.spongepowered.api.config.ConfigManager;
import org.spongepowered.api.config.ConfigRoot;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.config.DataSerializableTypeSerializer;
import org.spongepowered.common.config.PluginConfigRoot;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.reference.WatchServiceListener;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class PluginConfigManager
implements ConfigManager {
    private final TypeSerializerCollection serializers;
    private final WatchServiceListener listener = WatchServiceListener.builder().threadFactory(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Sponge-WatchService-%d").build()).build();

    @Inject
    PluginConfigManager(DataSerializableTypeSerializer dataSerializableSerializer) throws IOException {
        this.serializers = TypeSerializerCollection.defaults().childBuilder().register(DataSerializableTypeSerializer::accepts, dataSerializableSerializer).registerAll(SpongeAdventure.CONFIGURATE.serializers()).build();
    }

    @Override
    public ConfigRoot getSharedConfig(PluginContainer container) {
        return new PluginConfigRoot(this.serializers, container.getMetadata().getId().toLowerCase(), SpongeCommon.getPluginConfigDirectory());
    }

    @Override
    public ConfigRoot getPluginConfig(PluginContainer container) {
        return new PluginConfigRoot(this.serializers, container.getMetadata().getId().toLowerCase(), SpongeCommon.getPluginConfigDirectory().resolve(container.getMetadata().getId().toLowerCase()));
    }

    @Override
    public TypeSerializerCollection getSerializers() {
        return this.serializers;
    }

    @Override
    public WatchServiceListener getWatchServiceListener() {
        return this.listener;
    }

    public static ConfigurationOptions getOptions(TypeSerializerCollection serializers) {
        return ConfigurationOptions.defaults().serializers(serializers);
    }

    public void close() throws IOException {
        this.listener.close();
    }
}

