/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.inheritable;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class EntityCollisionCategory {
    @Setting
    @Comment(value="Per-mod overrides. Refer to the minecraft default mod for example.")
    public final Map<String, ModSubCategory> mods = new HashMap<String, ModSubCategory>();
    @Setting(value="auto-populate")
    @Comment(value="If 'true', newly discovered entities/blocks will be added to this config with a default value.")
    public boolean autoPopulate = false;
    @Setting(value="max-entities-within-aabb")
    @Comment(value="Maximum amount of entities any given entity or block can collide with. This improves \nperformance when there are more than 8 entities on top of each other such as a 1x1 \nspawn pen. Set to 0 to disable.")
    public int maxEntitiesWithinAABB = 8;

    public EntityCollisionCategory() {
        this.mods.put("minecraft", new ModSubCategory("minecraft"));
    }

    @ConfigSerializable
    public static final class ModSubCategory {
        @Setting(value="entity-default")
        public Integer entityDefault = 8;
        @Setting(value="block-default")
        public Integer blockDefault = 8;
        @Setting
        public final Map<String, Integer> blocks = new HashMap<String, Integer>();
        @Setting
        public final Map<String, Integer> entities = new HashMap<String, Integer>();
        @Setting
        @Comment(value="If 'false', entity collision rules for this mod will be ignored.")
        public boolean enabled = true;

        public ModSubCategory() {
        }

        public ModSubCategory(String namespace) {
            if (namespace.equals("minecraft")) {
                this.blocks.put("detector_rail", 1);
                this.blocks.put("heavy_weighted_pressure_plate", 150);
                this.blocks.put("light_weighted_pressure_plate", 15);
                this.blocks.put("mob_spawner", -1);
                this.blocks.put("stone_pressure_plate", 1);
                this.blocks.put("wooden_button", 1);
                this.blocks.put("wooden_pressure_plate", 1);
                this.entities.put("thrownpotion", -1);
            }
        }
    }
}

