/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.inheritable;

import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.config.inheritable.BaseConfig;
import org.spongepowered.common.config.inheritable.DuplicateRemovalVisitor;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.loader.ConfigurationLoader;

public final class InheritableConfigHandle<T extends BaseConfig>
extends ConfigHandle<T> {
    private final @Nullable InheritableConfigHandle<?> parent;
    private CommentedConfigurationNode mergedNode;

    public InheritableConfigHandle(T instance, @Nullable InheritableConfigHandle<?> parent) {
        super(instance);
        this.parent = parent;
    }

    public InheritableConfigHandle(T instance, ConfigurationLoader<? extends CommentedConfigurationNode> loader, @Nullable InheritableConfigHandle<?> parent) {
        super(instance, loader);
        this.parent = parent;
    }

    public <V> V getOrCreateValue(Function<T, V> getter, Consumer<BaseConfig> setter, boolean populate) {
        V ret = getter.apply(this.get());
        if (ret == null && populate) {
            setter.accept((BaseConfig)this.get());
            if (this.parent != null) {
                setter.accept((BaseConfig)this.parent.get());
            }
            ret = getter.apply(this.get());
        }
        return ret;
    }

    public void load() throws ConfigurateException {
        if (this.isAttached()) {
            this.node = (CommentedConfigurationNode)this.loader.load();
            this.doVersionUpdate();
            this.mergedNode = (CommentedConfigurationNode)this.node.copy();
        } else {
            this.mergedNode = CommentedConfigurationNode.root(SpongeConfigs.OPTIONS);
        }
        if (this.parent != null && this.parent.mergedNode != null) {
            this.mergedNode.mergeFrom(this.parent.mergedNode);
        }
        this.mapper.load(this.instance, this.mergedNode);
        this.doSave();
    }

    @Override
    public void doSave() throws ConfigurateException {
        if (!this.isAttached()) {
            return;
        }
        this.mapper.save(this.instance, this.node);
        if (this.parent != null) {
            this.removeDuplicates(this.node);
        }
        this.loader.save(this.node);
        if (this.parent != null) {
            this.parent.doSave();
        }
    }

    private void removeDuplicates(CommentedConfigurationNode root) {
        if (!this.isAttached()) {
            return;
        }
        if (this.parent == null) {
            throw new IllegalStateException("parent is null");
        }
        DuplicateRemovalVisitor.visit(root, this.parent.mergedNode);
    }
}

