/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataHolderBuilder;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.DataUpdaterDelegate;
import org.spongepowered.common.data.MemoryDataContainer;
import org.spongepowered.common.data.SpongeDataRegistration;
import org.spongepowered.common.data.builder.item.SpongeItemStackSnapshotDataBuilder;
import org.spongepowered.common.data.key.KeyBasedDataListener;
import org.spongepowered.common.data.persistence.datastore.DataStoreRegistry;
import org.spongepowered.common.data.provider.CustomDataProvider;
import org.spongepowered.common.data.provider.DataProviderRegistry;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.item.SpongeItemStackBuilder;
import org.spongepowered.common.registry.provider.DataTranslatorProvider;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.storage.SpongePlayerData;
import org.spongepowered.common.world.storage.SpongePlayerDataBuilder;

@Singleton
public final class SpongeDataManager
implements DataManager {
    public static SpongeDataManager INSTANCE;
    private final DataStoreRegistry dataStoreRegistry;
    private final DataProviderRegistry dataProviderRegistry;
    private final Map<Class<?>, DataBuilder<?>> builders;
    private final Map<Class<? extends DataHolder.Immutable<?>>, DataHolderBuilder.Immutable<?, ?>> immutableDataBuilderMap;
    private final Map<Class<? extends DataSerializable>, List<DataContentUpdater>> updatersMap;
    private final List<DataContentUpdater> customDataUpdaters;
    private final Map<String, SpongeDataRegistration> legacyRegistrations;
    private final List<KeyBasedDataListener<?>> keyListeners;
    private Map<Class<?>, RegistryType<?>> registryTypeMap;

    @Inject
    private SpongeDataManager() {
        INSTANCE = this;
        this.dataStoreRegistry = new DataStoreRegistry();
        this.dataProviderRegistry = new DataProviderRegistry();
        this.builders = new HashMap();
        this.immutableDataBuilderMap = new MapMaker().concurrencyLevel(4).makeMap();
        this.updatersMap = new IdentityHashMap<Class<? extends DataSerializable>, List<DataContentUpdater>>();
        this.customDataUpdaters = new ArrayList<DataContentUpdater>();
        this.legacyRegistrations = new HashMap<String, SpongeDataRegistration>();
        this.keyListeners = new ArrayList();
    }

    @Override
    public <T extends DataSerializable> void registerBuilder(Class<T> clazz, DataBuilder<T> builder) {
        Objects.requireNonNull(builder);
        if (this.builders.putIfAbsent(clazz, builder) != null) {
            SpongeCommon.getLogger().warn("A DataBuilder has already been registered for {}. Attempted to register {} instead.", (Object)clazz, (Object)builder.getClass());
        } else if (!(builder instanceof AbstractDataBuilder)) {
            SpongeCommon.getLogger().warn("A custom DataBuilder is not extending AbstractDataBuilder! It is recommended that the custom data builder does extend it to gain automated content versioning updates and maintain simplicity. The offending builder's class is: {}", (Object)builder.getClass());
        }
    }

    @Override
    public <T extends DataSerializable> void registerContentUpdater(Class<T> clazz, DataContentUpdater updater) {
        Objects.requireNonNull(updater);
        List updaters = this.updatersMap.computeIfAbsent(clazz, k -> new ArrayList());
        updaters.add(updater);
        updaters.sort(Constants.Functional.DATA_CONTENT_UPDATER_COMPARATOR);
    }

    public void registerCustomDataContentUpdater(DataContentUpdater updater) {
        this.customDataUpdaters.add(updater);
    }

    @Override
    public <T extends DataSerializable> Optional<DataContentUpdater> getWrappedContentUpdater(Class<T> clazz, int fromVersion, int toVersion) {
        if (fromVersion == toVersion) {
            throw new IllegalArgumentException("Attempting to convert to the same version!");
        }
        if (fromVersion < toVersion) {
            throw new IllegalArgumentException("Attempting to backwards convert data! This isn't supported!");
        }
        List<DataContentUpdater> updaters = this.updatersMap.get(clazz);
        if (updaters == null) {
            return Optional.empty();
        }
        return SpongeDataManager.getWrappedContentUpdater(clazz, fromVersion, toVersion, updaters);
    }

    public Optional<DataContentUpdater> getWrappedCustomContentUpdater(Class<DataManipulator.Mutable> mutableClass, int version, int currentCustomData) {
        return SpongeDataManager.getWrappedContentUpdater(mutableClass, version, currentCustomData, this.customDataUpdaters);
    }

    private static Optional<DataContentUpdater> getWrappedContentUpdater(Class<?> clazz, int fromVersion, int toVersion, List<DataContentUpdater> updaters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int version = fromVersion;
        for (DataContentUpdater updater : updaters) {
            if (updater.getInputVersion() != version || updater.getOutputVersion() > toVersion) continue;
            version = updater.getOutputVersion();
            builder.add((Object)updater);
        }
        if (version < toVersion || version > toVersion) {
            IllegalStateException e = new IllegalStateException("The requested content version for: " + clazz.getSimpleName() + " was requested, \nhowever, the versions supplied: from " + fromVersion + " to " + toVersion + " is impossible\nas the latest version registered is: " + version + ". Please notify the developer of\nthe requested consumed DataSerializable of this error.");
            e.printStackTrace();
            return Optional.empty();
        }
        return Optional.of(new DataUpdaterDelegate((ImmutableList<DataContentUpdater>)builder.build(), fromVersion, toVersion));
    }

    @Override
    public <T extends DataSerializable> Optional<DataBuilder<T>> getBuilder(Class<T> clazz) {
        DataBuilder<?> dataBuilder = this.builders.get(clazz);
        if (dataBuilder != null) {
            return Optional.of(dataBuilder);
        }
        return Optional.ofNullable((DataBuilder)((Object)this.immutableDataBuilderMap.get(clazz)));
    }

    @Override
    public <T extends DataSerializable> Optional<T> deserialize(Class<T> clazz, DataView dataView) {
        Objects.requireNonNull(dataView);
        return this.getBuilder(clazz).flatMap(builder -> builder.build(dataView));
    }

    @Override
    public <T extends DataHolder.Immutable<T>, B extends DataHolderBuilder.Immutable<T, B>> void register(Class<T> holderClass, B builder) {
        Objects.requireNonNull(builder);
        DataHolderBuilder.Immutable<?, ?> previous = this.immutableDataBuilderMap.putIfAbsent(holderClass, builder);
        if (previous != null) {
            throw new IllegalStateException("Already registered the DataUtil for " + holderClass.getCanonicalName());
        }
    }

    @Override
    public <T extends DataHolder.Immutable<T>, B extends DataHolderBuilder.Immutable<T, B>> Optional<B> getImmutableBuilder(Class<T> holderClass) {
        return Optional.ofNullable(this.immutableDataBuilderMap.get(Objects.requireNonNull(holderClass)));
    }

    @Override
    public <T> Optional<DataTranslator<T>> getTranslator(Class<T> objectClass) {
        return DataTranslatorProvider.INSTANCE.getSerializer(objectClass);
    }

    public void registerKeyListeners() {
        this.keyListeners.forEach(this::registerKeyListener0);
        this.keyListeners.clear();
    }

    private void registerKeyListener0(KeyBasedDataListener<?> listener) {
        Sponge.getEventManager().registerListener(listener.getOwner(), ChangeDataHolderEvent.ValueChange.class, listener);
    }

    @Override
    public void registerLegacyManipulatorIds(String legacyId, DataRegistration registration) {
        Objects.requireNonNull(legacyId);
        Objects.requireNonNull(registration);
        SpongeDataRegistration previous = this.legacyRegistrations.putIfAbsent(legacyId, (SpongeDataRegistration)registration);
        if (previous != null) {
            throw new IllegalStateException("Legacy registration id already registered: id" + legacyId + " for registration: " + registration);
        }
    }

    public Optional<DataRegistration> getRegistrationForLegacyId(String id) {
        return Optional.ofNullable(this.legacyRegistrations.get(id));
    }

    @Override
    public DataContainer createContainer() {
        return new MemoryDataContainer();
    }

    @Override
    public DataContainer createContainer(DataView.SafetyMode safety) {
        return new MemoryDataContainer(safety);
    }

    public <E extends DataHolder> void registerKeyListener(KeyBasedDataListener<E> keyListener) {
        Objects.requireNonNull(keyListener);
        this.keyListeners.add(keyListener);
    }

    public void registerCustomDataRegistration(SpongeDataRegistration registration) {
        for (DataStore dataStore : registration.getDataStores()) {
            this.dataStoreRegistry.register(dataStore, registration.getKeys());
        }
        for (Key key : registration.getKeys()) {
            this.registerCustomDataProviderForKey(registration, key);
        }
    }

    private <V extends Value<E>, E> void registerCustomDataProviderForKey(SpongeDataRegistration registration, Key<V> key) {
        Collection providers = registration.getProvidersFor(key);
        HashSet<Type> dataStoreSupportedTokens = new HashSet<Type>();
        this.dataStoreRegistry.getDataStores(key).stream().map(DataStore::getSupportedTypes).forEach(dataStoreSupportedTokens::addAll);
        for (DataProvider provider : providers) {
            this.dataProviderRegistry.register(provider);
            dataStoreSupportedTokens.removeIf(provider::isSupported);
        }
        if (!dataStoreSupportedTokens.isEmpty()) {
            this.dataProviderRegistry.register(new CustomDataProvider(key, dataStoreSupportedTokens));
        }
    }

    public void registerDataRegistration(SpongeDataRegistration registration) {
        for (DataStore dataStore : registration.getDataStores()) {
            this.dataStoreRegistry.register(dataStore, registration.getKeys());
        }
        for (Key key : registration.getKeys()) {
            Collection providers = registration.getProvidersFor(key);
            for (DataProvider provider : providers) {
                this.dataProviderRegistry.register(provider);
            }
        }
    }

    public void registerDefaultProviders() {
        this.dataProviderRegistry.registerDefaultProviders();
    }

    public static DataStoreRegistry getDatastoreRegistry() {
        return SpongeDataManager.INSTANCE.dataStoreRegistry;
    }

    public static DataProviderRegistry getProviderRegistry() {
        return SpongeDataManager.INSTANCE.dataProviderRegistry;
    }

    public void registerDefaultBuilders() {
        this.registerBuilder(ItemStack.class, new SpongeItemStackBuilder());
        this.registerBuilder(ItemStackSnapshot.class, new SpongeItemStackSnapshotDataBuilder());
        this.registerBuilder(EntitySnapshot.class, new SpongeEntitySnapshotBuilder());
        this.registerBuilder(EntityArchetype.class, new SpongeEntityArchetypeBuilder());
        this.registerBuilder(SpongePlayerData.class, new SpongePlayerDataBuilder());
    }

    public Optional<DataStore> getDataStore(ResourceKey key, Class<? extends DataHolder> typeToken) {
        return this.dataStoreRegistry.getDataStore(key, typeToken);
    }

    public <T> Optional<RegistryType<T>> findRegistryTypeFor(Class type) {
        RegistryType<?> directMatch;
        if (this.registryTypeMap == null) {
            this.registryTypeMap = new HashMap();
            this.registryTypeMap.put(ItemType.class, RegistryTypes.ITEM_TYPE);
        }
        if ((directMatch = this.registryTypeMap.get(type)) != null) {
            return Optional.of(directMatch);
        }
        for (Map.Entry<Class<?>, RegistryType<?>> entry : this.registryTypeMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            this.registryTypeMap.put(type, entry.getValue());
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }
}

