/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.holder;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.common.data.holder.SpongeDataHolder;
import org.spongepowered.common.data.key.SpongeKey;
import org.spongepowered.common.util.DataUtil;

public interface SpongeMutableDataHolder
extends SpongeDataHolder,
DataHolder.Mutable {
    @Override
    default public DataHolder.Mutable delegateDataHolder() {
        return this;
    }

    @Override
    default public <E> DataTransactionResult tryOffer(Key<? extends Value<E>> key, E value) {
        DataTransactionResult result = this.offer(key, value);
        if (!result.isSuccessful()) {
            throw new IllegalArgumentException("Failed offer transaction!");
        }
        return result;
    }

    @Override
    default public <E> DataTransactionResult offer(Key<? extends Value<E>> key, E value) {
        return this.getProviderFor(Objects.requireNonNull(key, "key")).offer(this.delegateDataHolder(), value);
    }

    @Override
    default public DataTransactionResult offer(Value<?> value) {
        return this.getProviderFor(value.getKey()).offerValue(this.delegateDataHolder(), value);
    }

    @Override
    default public <E> DataTransactionResult offerSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        SpongeKey key0 = (SpongeKey)key;
        DataProvider provider = this.getProviderFor(key0);
        if (!provider.isSupported(this.delegateDataHolder())) {
            return DataTransactionResult.failNoData();
        }
        Collection collection = provider.get(this.delegateDataHolder()).map(DataUtil::ensureMutable).orElseGet(key0.getDefaultValueSupplier());
        if (!collection.add(element)) {
            return DataTransactionResult.failNoData();
        }
        return provider.offer(this.delegateDataHolder(), collection);
    }

    @Override
    default public <E> DataTransactionResult offerAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        SpongeKey key0 = (SpongeKey)key;
        DataProvider provider = this.getProviderFor(key0);
        if (!provider.isSupported(this.delegateDataHolder())) {
            return DataTransactionResult.failNoData();
        }
        Collection collection = provider.get(this.delegateDataHolder()).map(DataUtil::ensureMutable).orElseGet(key0.getDefaultValueSupplier());
        if (!collection.addAll(elements)) {
            return DataTransactionResult.failNoData();
        }
        return provider.offer(this.delegateDataHolder(), collection);
    }

    @Override
    default public DataTransactionResult offerAll(CollectionValue<?, ?> value) {
        return this.offerAll(value.getKey(), (Collection)value.get());
    }

    @Override
    default public <K, V> DataTransactionResult offerSingle(Key<? extends MapValue<K, V>> key, K valueKey, V value) {
        DataProvider<MapValue<K, V>, Map> provider = this.getProviderFor(key);
        if (!provider.isSupported(this.delegateDataHolder())) {
            return DataTransactionResult.failNoData();
        }
        Map copy = provider.get(this.delegateDataHolder()).map(DataUtil::ensureMutable).orElseGet(((SpongeKey)key).getDefaultValueSupplier());
        copy.put(valueKey, value);
        return provider.offer(this.delegateDataHolder(), copy);
    }

    @Override
    default public <K, V> DataTransactionResult offerAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> values) {
        if (values.isEmpty()) {
            return DataTransactionResult.failNoData();
        }
        DataProvider<MapValue<K, V>, Map> provider = this.getProviderFor(key);
        if (!provider.isSupported(this.delegateDataHolder())) {
            return DataTransactionResult.failNoData();
        }
        Map map = provider.get(this.delegateDataHolder()).map(DataUtil::ensureMutable).orElseGet(((SpongeKey)key).getDefaultValueSupplier());
        map.putAll(values);
        return provider.offer(this.delegateDataHolder(), map);
    }

    @Override
    default public DataTransactionResult offerAll(MapValue<?, ?> value) {
        return this.offerAll(value.getKey(), (Map)value.get());
    }

    @Override
    default public <E> DataTransactionResult removeSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        SpongeKey key0 = (SpongeKey)key;
        DataProvider provider = this.getProviderFor(key0);
        if (!provider.isSupported(this.delegateDataHolder())) {
            return DataTransactionResult.failNoData();
        }
        Optional<Collection> optCollection = provider.get(this.delegateDataHolder()).map(DataUtil::ensureMutable);
        if (!optCollection.isPresent()) {
            return DataTransactionResult.failNoData();
        }
        Collection collection = optCollection.get();
        if (!collection.remove(element)) {
            return DataTransactionResult.failNoData();
        }
        return provider.offer(this.delegateDataHolder(), collection);
    }

    @Override
    default public <E> DataTransactionResult removeAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        if (elements.isEmpty()) {
            return DataTransactionResult.failNoData();
        }
        SpongeKey key0 = (SpongeKey)key;
        DataProvider provider = this.getProviderFor(key0);
        if (!provider.isSupported(this.delegateDataHolder())) {
            return DataTransactionResult.failNoData();
        }
        Optional<Collection> optCollection = provider.get(this.delegateDataHolder()).map(DataUtil::ensureMutable);
        if (!optCollection.isPresent()) {
            return DataTransactionResult.failNoData();
        }
        Collection collection = optCollection.get();
        if (!collection.removeAll(elements)) {
            return DataTransactionResult.failNoData();
        }
        return provider.offer(this, collection);
    }

    @Override
    default public DataTransactionResult removeAll(CollectionValue<?, ?> value) {
        return this.removeAll(value.getKey(), (Collection)value.get());
    }

    @Override
    default public <K> DataTransactionResult removeKey(Key<? extends MapValue<K, ?>> key, K mapKey) {
        SpongeKey key0 = (SpongeKey)key;
        DataProvider provider = this.getProviderFor(key0);
        if (!provider.isSupported(this.delegateDataHolder())) {
            return DataTransactionResult.failNoData();
        }
        Optional optionalMap = provider.get(this.delegateDataHolder());
        if (!optionalMap.isPresent() || !((Map)optionalMap.get()).containsKey(mapKey)) {
            return DataTransactionResult.failNoData();
        }
        Map map = DataUtil.ensureMutable((Map)optionalMap.get());
        map.remove(mapKey);
        return provider.offer(this.delegateDataHolder(), map);
    }

    @Override
    default public <K, V> DataTransactionResult removeAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> values) {
        if (values.isEmpty()) {
            return DataTransactionResult.failNoData();
        }
        DataProvider<MapValue<K, V>, Map> provider = this.getProviderFor(key);
        if (!provider.isSupported(this.delegateDataHolder())) {
            return DataTransactionResult.failNoData();
        }
        Optional<Map> optionalMap = provider.get(this.delegateDataHolder()).map(DataUtil::ensureMutable);
        if (!optionalMap.isPresent()) {
            return DataTransactionResult.failNoData();
        }
        Map map = optionalMap.get();
        for (Map.Entry<K, V> entry : values.entrySet()) {
            map.remove(entry.getKey(), entry.getValue());
        }
        return provider.offer(this.delegateDataHolder(), map);
    }

    @Override
    default public DataTransactionResult removeAll(MapValue<?, ?> value) {
        return this.removeAll(value.getKey(), (Map)value.get());
    }

    @Override
    default public DataTransactionResult remove(Key<?> key) {
        return this.getProviderFor(key).remove(this.delegateDataHolder());
    }

    @Override
    default public DataTransactionResult remove(Value<?> value) {
        Key<Value<?>> key = value.getKey();
        DataProvider provider = this.getProviderFor(key);
        Optional optionalElement = provider.get(this.delegateDataHolder());
        if (!optionalElement.isPresent() || !optionalElement.get().equals(value.get())) {
            return DataTransactionResult.failNoData();
        }
        return provider.remove(this.delegateDataHolder());
    }

    @Override
    default public DataTransactionResult copyFrom(ValueContainer that, MergeFunction function) {
        Objects.requireNonNull(that, "that");
        Objects.requireNonNull(function, "function");
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        boolean success = false;
        if (function == MergeFunction.REPLACEMENT_PREFERRED) {
            for (Value value : that.getValues()) {
                DataTransactionResult result = this.offer(value);
                builder.absorbResult(result);
                if (!result.isSuccessful()) continue;
                success = true;
            }
        } else if (function == MergeFunction.ORIGINAL_PREFERRED) {
            for (Value value : that.getValues()) {
                Key key = value.getKey();
                if (this.get(key).isPresent()) continue;
                Value merged = function.merge(null, value);
                DataTransactionResult result = this.offer(merged);
                builder.absorbResult(result);
                if (!result.isSuccessful()) continue;
                success = true;
            }
        } else {
            for (Value value : that.getValues()) {
                Key key = value.getKey();
                @Nullable Value original = this.getValue(key).map(Value::asImmutable).orElse(null);
                Value merged = function.merge(original, value);
                DataTransactionResult result = this.offer(merged);
                builder.absorbResult(result);
                if (!result.isSuccessful()) continue;
                success = true;
            }
        }
        if (success) {
            builder.result(DataTransactionResult.Type.SUCCESS);
        } else {
            builder.result(DataTransactionResult.Type.FAILURE);
        }
        return builder.build();
    }

    @Override
    default public DataTransactionResult undo(DataTransactionResult result) {
        if (result.getReplacedData().isEmpty() && result.getSuccessfulData().isEmpty()) {
            return DataTransactionResult.successNoData();
        }
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (Value value : result.getReplacedData()) {
            builder.absorbResult(this.offer(value));
        }
        for (Value value : result.getSuccessfulData()) {
            builder.absorbResult(this.remove(value));
        }
        return DataTransactionResult.failNoData();
    }
}

