/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;

public final class NBTTranslator
implements DataTranslator<CompoundNBT> {
    public static final NBTTranslator INSTANCE = new NBTTranslator();
    private static final TypeToken<CompoundNBT> TOKEN = TypeToken.get(CompoundNBT.class);
    public static final String BOOLEAN_IDENTIFIER = "$Boolean";

    private static CompoundNBT containerToCompound(DataView container) {
        Preconditions.checkNotNull((Object)container);
        CompoundNBT compound = new CompoundNBT();
        NBTTranslator.containerToCompound(container, compound);
        return compound;
    }

    private static void containerToCompound(DataView container, CompoundNBT compound) {
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)compound);
        for (Map.Entry<DataQuery, Object> entry : container.getValues(false).entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey().asString('.');
            if (value instanceof DataView) {
                CompoundNBT inner = new CompoundNBT();
                NBTTranslator.containerToCompound(container.getView(entry.getKey()).get(), inner);
                compound.func_218657_a(key, (INBT)inner);
                continue;
            }
            if (value instanceof Boolean) {
                compound.func_218657_a(key + BOOLEAN_IDENTIFIER, (INBT)ByteNBT.func_229672_a_((boolean)((Boolean)value)));
                continue;
            }
            compound.func_218657_a(key, NBTTranslator.getBaseFromObject(value));
        }
    }

    private static INBT getBaseFromObject(Object value) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof Boolean) {
            return ByteNBT.func_229672_a_((boolean)((Boolean)value));
        }
        if (value instanceof Byte) {
            return ByteNBT.func_229671_a_((byte)((Byte)value));
        }
        if (value instanceof Short) {
            return ShortNBT.func_229701_a_((short)((Short)value));
        }
        if (value instanceof Integer) {
            return IntNBT.func_229692_a_((int)((Integer)value));
        }
        if (value instanceof Long) {
            return LongNBT.func_229698_a_((long)((Long)value));
        }
        if (value instanceof Float) {
            return FloatNBT.func_229689_a_((float)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DoubleNBT.func_229684_a_((double)((Double)value));
        }
        if (value instanceof String) {
            return StringNBT.func_229705_a_((String)((String)value));
        }
        if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                return new ByteArrayNBT((byte[])value);
            }
            if (value instanceof Byte[]) {
                byte[] array = new byte[((Byte[])value).length];
                int counter = 0;
                for (Byte data : (Byte[])value) {
                    array[counter++] = data;
                }
                return new ByteArrayNBT(array);
            }
            if (value instanceof int[]) {
                return new IntArrayNBT((int[])value);
            }
            if (value instanceof Integer[]) {
                int[] array = new int[((Integer[])value).length];
                int counter = 0;
                for (Integer data : (Integer[])value) {
                    array[counter++] = data;
                }
                return new IntArrayNBT(array);
            }
            if (value instanceof long[]) {
                return new LongArrayNBT((long[])value);
            }
            if (value instanceof Long[]) {
                long[] array = new long[((Long[])value).length];
                int counter = 0;
                for (Long data : (Long[])value) {
                    array[counter++] = data;
                }
                return new LongArrayNBT(array);
            }
        } else {
            if (value instanceof List) {
                ListNBT list = new ListNBT();
                for (Object object : (List)value) {
                    list.add((Object)NBTTranslator.getBaseFromObject(object));
                }
                return list;
            }
            if (value instanceof Map) {
                CompoundNBT compound = new CompoundNBT();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    if (entry.getKey() instanceof DataQuery) {
                        if (entry.getValue() instanceof Boolean) {
                            compound.func_74757_a(((DataQuery)entry.getKey()).asString('.') + BOOLEAN_IDENTIFIER, ((Boolean)entry.getValue()).booleanValue());
                            continue;
                        }
                        compound.func_218657_a(((DataQuery)entry.getKey()).asString('.'), NBTTranslator.getBaseFromObject(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey() instanceof String) {
                        compound.func_218657_a((String)entry.getKey(), NBTTranslator.getBaseFromObject(entry.getValue()));
                        continue;
                    }
                    compound.func_218657_a(entry.getKey().toString(), NBTTranslator.getBaseFromObject(entry.getValue()));
                }
                return compound;
            }
            if (value instanceof DataSerializable) {
                return NBTTranslator.containerToCompound(((DataSerializable)value).toContainer());
            }
            if (value instanceof DataView) {
                return NBTTranslator.containerToCompound((DataView)value);
            }
        }
        throw new IllegalArgumentException("Unable to translate object to NBTBase: " + value);
    }

    private static DataContainer getViewFromCompound(CompoundNBT compound) {
        Preconditions.checkNotNull((Object)compound);
        DataContainer container = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
        INSTANCE.addTo(compound, (DataView)container);
        return container;
    }

    private static void setInternal(INBT base, byte type, DataView view, String key) {
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)view);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((type > 0 && type <= 11 ? 1 : 0) != 0);
        switch (type) {
            case 1: {
                if (key.contains(BOOLEAN_IDENTIFIER)) {
                    view.set(DataQuery.of(key.replace(BOOLEAN_IDENTIFIER, "")), ((ByteNBT)base).func_150290_f() != 0);
                    break;
                }
                view.set(DataQuery.of(key), ((ByteNBT)base).func_150290_f());
                break;
            }
            case 2: {
                view.set(DataQuery.of(key), ((ShortNBT)base).func_150289_e());
                break;
            }
            case 3: {
                view.set(DataQuery.of(key), ((IntNBT)base).func_150287_d());
                break;
            }
            case 4: {
                view.set(DataQuery.of(key), ((LongNBT)base).func_150291_c());
                break;
            }
            case 5: {
                view.set(DataQuery.of(key), Float.valueOf(((FloatNBT)base).func_150288_h()));
                break;
            }
            case 6: {
                view.set(DataQuery.of(key), ((DoubleNBT)base).func_150286_g());
                break;
            }
            case 7: {
                view.set(DataQuery.of(key), ((ByteArrayNBT)base).func_150292_c());
                break;
            }
            case 8: {
                view.set(DataQuery.of(key), base.func_150285_a_());
                break;
            }
            case 9: {
                ListNBT list = (ListNBT)base;
                byte listType = list.func_230528_d__();
                int count = list.size();
                ArrayList objectList = Lists.newArrayListWithCapacity((int)count);
                for (INBT inbt : list) {
                    objectList.add(NBTTranslator.fromTagBase(inbt, listType));
                }
                view.set(DataQuery.of(key), objectList);
                break;
            }
            case 10: {
                DataView internalView = view.createView(DataQuery.of(key));
                CompoundNBT compound = (CompoundNBT)base;
                for (String internalKey : compound.func_150296_c()) {
                    INBT internalBase = compound.func_74781_a(internalKey);
                    byte internalType = internalBase.func_74732_a();
                    NBTTranslator.setInternal(internalBase, internalType, internalView, internalKey);
                }
                break;
            }
            case 11: {
                view.set(DataQuery.of(key), ((IntArrayNBT)base).func_150302_c());
                break;
            }
            case 12: {
                view.set(DataQuery.of(key), ((LongArrayNBT)base).func_197652_h());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown NBT type " + type);
            }
        }
    }

    private static Object fromTagBase(INBT base, byte type) {
        switch (type) {
            case 1: {
                return ((ByteNBT)base).func_150290_f();
            }
            case 2: {
                return ((ShortNBT)base).func_150289_e();
            }
            case 3: {
                return ((IntNBT)base).func_150287_d();
            }
            case 4: {
                return ((LongNBT)base).func_150291_c();
            }
            case 5: {
                return Float.valueOf(((FloatNBT)base).func_150288_h());
            }
            case 6: {
                return ((DoubleNBT)base).func_150286_g();
            }
            case 7: {
                return ((ByteArrayNBT)base).func_150292_c();
            }
            case 8: {
                return base.func_150285_a_();
            }
            case 9: {
                ListNBT list = (ListNBT)base;
                byte listType = list.func_230528_d__();
                int count = list.size();
                ArrayList objectList = Lists.newArrayListWithCapacity((int)count);
                for (INBT inbt : list) {
                    objectList.add(NBTTranslator.fromTagBase(inbt, listType));
                }
                return objectList;
            }
            case 10: {
                return NBTTranslator.getViewFromCompound((CompoundNBT)base);
            }
            case 11: {
                return ((IntArrayNBT)base).func_150302_c();
            }
            case 12: {
                return ((LongArrayNBT)base).func_197652_h();
            }
        }
        return null;
    }

    public void translateContainerToData(CompoundNBT node, DataView container) {
        NBTTranslator.containerToCompound(container, node);
    }

    public DataContainer translateFrom(CompoundNBT node) {
        return NBTTranslator.getViewFromCompound(node);
    }

    @Override
    public TypeToken<CompoundNBT> getToken() {
        return TOKEN;
    }

    @Override
    public CompoundNBT translate(DataView view) throws InvalidDataException {
        return NBTTranslator.containerToCompound(view);
    }

    @Override
    public DataContainer translate(CompoundNBT obj) throws InvalidDataException {
        return NBTTranslator.getViewFromCompound(obj);
    }

    @Override
    public DataView addTo(CompoundNBT compound, DataView container) {
        for (String key : compound.func_150296_c()) {
            INBT base = compound.func_74781_a(key);
            byte type = base.func_74732_a();
            NBTTranslator.setInternal(base, type, container, key);
        }
        return container;
    }
}

