/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;
import org.spongepowered.common.util.NBTStreams;

public final class BlockTypeItemStackData {
    private BlockTypeItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.BREAKABLE_BLOCK_TYPES).get(h2 -> BlockTypeItemStackData.get(h2, "CanDestroy"))).set((h2, v) -> BlockTypeItemStackData.set(h2, "CanDestroy", v))).create(Keys.PLACEABLE_BLOCK_TYPES).get(h2 -> BlockTypeItemStackData.get(h2, "CanPlaceOn"))).set((h2, v) -> BlockTypeItemStackData.set(h2, "CanPlaceOn", v));
    }

    private static Set<BlockType> get(ItemStack stack, String nbtKey) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        ListNBT list = tag.func_150295_c(nbtKey, 8);
        if (list.isEmpty()) {
            return null;
        }
        return NBTStreams.toStrings((Iterable<INBT>)list).map(ResourceLocation::func_208304_a).filter(Objects::nonNull).map(key -> Registry.field_212618_g.func_241873_b(key).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static boolean set(ItemStack stack, String nbtKey, Set<? extends BlockType> value) {
        if (value.isEmpty()) {
            stack.func_196083_e(nbtKey);
            return true;
        }
        CompoundNBT tag = stack.func_196082_o();
        ListNBT list = value.stream().map(type -> Registry.field_212618_g.func_177774_c((Object)((Block)type)).toString()).collect(NBTCollectors.toStringTagList());
        tag.func_218657_a(nbtKey, (INBT)list);
        return true;
    }
}

