/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;

public final class BookItemStackData {
    private BookItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.AUTHOR).get(h2 -> {
            CompoundNBT tag = h2.func_77978_p();
            if (tag == null) {
                return null;
            }
            return SpongeAdventure.legacySection(tag.func_74779_i("author"));
        })).set((h2, v) -> h2.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)SpongeAdventure.legacySection(v))))).supports(h2 -> h2.func_77973_b() == Items.field_151164_bB)).create(Keys.GENERATION).get(h2 -> {
            CompoundNBT tag = h2.func_77978_p();
            if (tag == null) {
                return null;
            }
            return tag.func_74762_e("generation");
        })).setAnd((h2, v) -> {
            if (v < 0) {
                return false;
            }
            h2.func_77983_a("generation", (INBT)IntNBT.func_229692_a_((int)v));
            return true;
        })).supports(h2 -> h2.func_77973_b() == Items.field_151164_bB)).create(Keys.PAGES).get(h2 -> BookItemStackData.get(h2, iv -> GsonComponentSerializer.gson().deserialize(iv)))).setAnd((h2, v) -> BookItemStackData.set(h2, v, ih -> (String)GsonComponentSerializer.gson().serialize(ih)))).deleteAnd(BookItemStackData::delete)).supports(h2 -> h2.func_77973_b() == Items.field_151164_bB)).create(Keys.PLAIN_PAGES).get(h2 -> BookItemStackData.get(h2, iv -> iv))).setAnd((h2, v) -> BookItemStackData.set(h2, v, iv -> iv))).deleteAnd(BookItemStackData::delete)).supports(h2 -> h2.func_77973_b() == Items.field_151099_bA);
    }

    private static <V> List<V> get(ItemStack holder, Function<String, V> predicate) {
        CompoundNBT tag = holder.func_77978_p();
        if (tag == null || !tag.func_74764_b("pages")) {
            return null;
        }
        ListNBT list = tag.func_150295_c("pages", 8);
        return list.stream().map(INBT::func_150285_a_).map(predicate).collect(Collectors.toList());
    }

    private static <V> boolean set(ItemStack holder, List<V> value, Function<V, String> predicate) {
        ListNBT list = value.stream().map(predicate).collect(NBTCollectors.toStringTagList());
        holder.func_77983_a("pages", (INBT)list);
        CompoundNBT compound = holder.func_196082_o();
        if (!compound.func_74764_b("title")) {
            compound.func_74778_a("title", "invalid");
        }
        if (!compound.func_74764_b("author")) {
            compound.func_74778_a("author", "invalid");
        }
        compound.func_74757_a("resolved", true);
        return false;
    }

    private static boolean delete(ItemStack holder) {
        CompoundNBT tag = holder.func_77978_p();
        if (tag != null && tag.func_150297_b("pages", 9)) {
            tag.func_82580_o("pages");
            return true;
        }
        return false;
    }
}

