/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.NestedTableEntry;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.accessor.item.ToolItemAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;

public final class ItemStackData {
    private ItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.APPLICABLE_POTION_EFFECTS).get(h2 -> {
            if (h2.func_222117_E()) {
                List itemEffects = h2.func_77973_b().func_219967_s().func_221464_f();
                WeightedTable effects = new WeightedTable();
                ChanceTable<PotionEffect> chance = new ChanceTable<PotionEffect>();
                for (Pair effect : itemEffects) {
                    chance.add((PotionEffect)effect.getFirst(), ((Float)effect.getSecond()).floatValue());
                }
                effects.add(new NestedTableEntry(1.0, chance));
                return effects;
            }
            return null;
        })).create(Keys.BURN_TIME).get(h2 -> {
            Integer burnTime = (Integer)AbstractFurnaceTileEntity.func_214001_f().get(h2.func_77973_b());
            if (burnTime != null && burnTime > 0) {
                return burnTime;
            }
            return null;
        })).create(Keys.CAN_HARVEST).get(h2 -> {
            Item item = h2.func_77973_b();
            if (item instanceof ToolItemAccessor && !(item instanceof PickaxeItem)) {
                Set<Block> blocks = ((ToolItemAccessor)item).accessor$blocks();
                return ImmutableSet.copyOf(blocks);
            }
            Set blockTypes = (Set)Registry.field_212618_g.func_201756_e().filter(b -> item.func_150897_b(b.func_176223_P())).map(BlockType.class::cast).collect(ImmutableSet.toImmutableSet());
            return blockTypes.isEmpty() ? null : blockTypes;
        })).create(Keys.CONTAINER_ITEM).get(h2 -> (ItemType)h2.func_77973_b().func_77668_q())).create(Keys.DISPLAY_NAME).get(h2 -> {
            CompoundNBT tag;
            if (h2.func_77973_b() == Items.field_151164_bB && (tag = h2.func_77978_p()) != null) {
                String title = tag.func_74779_i("title");
                return SpongeAdventure.legacySection(title);
            }
            return SpongeAdventure.asAdventure(h2.func_151000_E());
        })).setAnd((h2, v) -> {
            if (h2.func_77973_b() == Items.field_151164_bB) {
                String legacy = SpongeAdventure.legacySection(v);
                h2.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)legacy));
                return true;
            }
            return false;
        })).create(Keys.CUSTOM_MODEL_DATA).get(h2 -> {
            CompoundNBT tag = h2.func_77978_p();
            if (tag == null || !tag.func_150297_b("CustomModelData", 3)) {
                return null;
            }
            return tag.func_74762_e("CustomModelData");
        })).set((h2, v) -> {
            CompoundNBT tag = h2.func_196082_o();
            tag.func_74768_a("CustomModelData", v.intValue());
        })).delete(h2 -> {
            CompoundNBT tag = h2.func_77978_p();
            if (tag != null) {
                tag.func_82580_o("CustomModelData");
            }
        })).create(Keys.CUSTOM_NAME).get(h2 -> h2.func_82837_s() ? SpongeAdventure.asAdventure(h2.func_200301_q()) : null)).set((h2, v) -> h2.func_200302_a(SpongeAdventure.asVanilla(v)))).delete(ItemStack::func_135074_t)).create(Keys.IS_UNBREAKABLE).get(h2 -> {
            CompoundNBT tag = h2.func_77978_p();
            if (tag == null || !tag.func_150297_b("Unbreakable", 1)) {
                return false;
            }
            return tag.func_74767_n("Unbreakable");
        })).set(ItemStackData::setIsUnbrekable)).delete(h2 -> ItemStackData.setIsUnbrekable(h2, false))).create(Keys.LORE).get(h2 -> {
            CompoundNBT tag = h2.func_77978_p();
            if (tag == null || tag.func_74764_b("display")) {
                return null;
            }
            ListNBT list = tag.func_150295_c("Lore", 8);
            return list.isEmpty() ? null : SpongeAdventure.json(list.stream().collect(NBTCollectors.toStringList()));
        })).set((h2, v) -> {
            if (v.isEmpty()) {
                ItemStackData.deleteLore(h2);
                return;
            }
            ListNBT list = SpongeAdventure.listTagJson(v);
            h2.func_190925_c("display").func_218657_a("Lore", (INBT)list);
        })).delete(ItemStackData::deleteLore)).create(Keys.MAX_DURABILITY).get(h2 -> h2.func_77973_b().func_77645_m() ? Integer.valueOf(h2.func_77973_b().func_77612_l()) : null)).supports(h2 -> h2.func_77973_b().func_77645_m())).create(Keys.ITEM_DURABILITY).get(stack -> stack.func_77958_k() - stack.func_77952_i())).set((stack, durability) -> stack.func_196085_b(stack.func_77958_k() - durability))).supports(h2 -> h2.func_77973_b().func_77645_m())).create(Keys.REPLENISHED_FOOD).get(h2 -> {
            if (h2.func_77973_b().func_219971_r()) {
                Food food = h2.func_77973_b().func_219967_s();
                return food == null ? null : Integer.valueOf(food.func_221466_a());
            }
            return null;
        })).supports(h2 -> h2.func_77973_b().func_219971_r())).create(Keys.REPLENISHED_SATURATION).get(h2 -> {
            Food food;
            if (h2.func_77973_b().func_219971_r() && (food = h2.func_77973_b().func_219967_s()) != null) {
                return (double)(food.func_221469_b() * (float)food.func_221466_a()) * 2.0;
            }
            return null;
        })).supports(h2 -> h2.func_77973_b().func_219971_r());
    }

    private static void setIsUnbrekable(ItemStack stack, Boolean value) {
        if (value == null || !value.booleanValue() && !stack.func_77942_o()) {
            return;
        }
        CompoundNBT tag = stack.func_196082_o();
        if (value.booleanValue()) {
            tag.func_74757_a("Unbreakable", true);
        } else {
            tag.func_82580_o("Unbreakable");
        }
    }

    private static void deleteLore(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("display")) {
            tag.func_74775_l("display").func_82580_o("Lore");
        }
    }
}

