/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.common.data.value.AbstractImmutableSpongeValue;

public abstract class ImmutableSpongeCollectionValue<E, C extends Collection<E>, I extends CollectionValue.Immutable<E, C, I, M>, M extends CollectionValue.Mutable<E, C, M, I>>
extends AbstractImmutableSpongeValue<C>
implements CollectionValue.Immutable<E, C, I, M> {
    public ImmutableSpongeCollectionValue(Key<? extends CollectionValue<E, C>> key, C element) {
        super(key, element);
    }

    @Override
    public int size() {
        return ((Collection)this.element).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Collection)this.element).isEmpty();
    }

    @Override
    public boolean contains(E element) {
        return ((Collection)this.element).contains(element);
    }

    @Override
    public boolean containsAll(Iterable<E> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)this.element).containsAll((Collection)iterable);
        }
        return Streams.stream(iterable).allMatch(this::contains);
    }

    @Override
    public C getAll() {
        return (C)((Collection)this.get());
    }

    protected abstract I modifyCollection(Consumer<C> var1);

    @Override
    public I withElement(E element) {
        return this.modifyCollection(collection -> collection.add(element));
    }

    @Override
    public I withAll(Iterable<E> elements) {
        return this.modifyCollection(collection -> Iterables.addAll((Collection)collection, (Iterable)elements));
    }

    @Override
    public I without(E element) {
        if (!this.contains(element)) {
            return (I)this;
        }
        return this.modifyCollection(collection -> collection.remove(element));
    }

    @Override
    public I withoutAll(Iterable<E> elements) {
        if (Streams.stream(elements).noneMatch(this::contains)) {
            return (I)this;
        }
        return this.modifyCollection(collection -> elements.forEach(collection::remove));
    }

    @Override
    public I withoutAll(Predicate<E> predicate) {
        return this.modifyCollection(collection -> collection.removeIf(predicate));
    }

    @Override
    public I transform(Function<C, C> function) {
        return this.with((Collection)function.apply(this.get()));
    }

    @Override
    public Iterator<E> iterator() {
        return ((Collection)this.get()).iterator();
    }
}

