/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.datapack.DataPackSerializable;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.common.datapack.DataPackSerializedObject;
import org.spongepowered.common.datapack.SpongeDataPackType;
import org.spongepowered.common.event.lifecycle.RegisterDataPackValueEventImpl;
import org.spongepowered.common.item.recipe.ingredient.ResultUtil;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;

public final class SpongeDataPackManager {
    public static SpongeDataPackManager INSTANCE = new SpongeDataPackManager(Sponge.getGame());
    private final Game game;
    private final Map<SpongeDataPackType, List<DataPackSerializable>> serializables;

    private SpongeDataPackManager(Game game) {
        INSTANCE = this;
        this.game = game;
        this.serializables = new Object2ObjectOpenHashMap();
    }

    public void callRegisterDataPackValueEvents() {
        SpongeIngredient.clearCache();
        ResultUtil.clearCache();
        this.reset();
        this.serializables.putAll(this.callRegisterDataPackValueEvent((SpongeDataPackType)DataPackTypes.ADVANCEMENT));
        this.serializables.putAll(this.callRegisterDataPackValueEvent((SpongeDataPackType)DataPackTypes.RECIPE));
        this.serializables.putAll(this.callRegisterDataPackValueEvent((SpongeDataPackType)DataPackTypes.WORLD_TYPE));
        this.serializables.putAll(this.callRegisterDataPackValueEvent((SpongeDataPackType)DataPackTypes.WORLD));
    }

    public void serialize(Path dataPacksDirectory, Collection<String> dataPacksToLoad) throws IOException {
        for (Map.Entry<SpongeDataPackType, List<DataPackSerializable>> entry : this.serializables.entrySet()) {
            SpongeDataPackType key = entry.getKey();
            List<DataPackSerializable> value = entry.getValue();
            ArrayList<DataPackSerializedObject> serialized = new ArrayList<DataPackSerializedObject>();
            for (DataPackSerializable serializable : value) {
                JsonObject o = (JsonObject)key.getObjectSerializer().serialize(serializable);
                serialized.add((DataPackSerializedObject)key.getObjectFunction().apply(serializable, o));
            }
            try {
                if (key.getPackSerializer().serialize(key, dataPacksDirectory, serialized)) {
                    dataPacksToLoad.add("file/" + key.getPackSerializer().getPackName());
                    continue;
                }
                dataPacksToLoad.remove("file/" + key.getPackSerializer().getPackName());
            }
            catch (IOException e) {
                dataPacksToLoad.remove("file/" + key.getPackSerializer().getPackName());
                throw e;
            }
        }
        this.reset();
    }

    private <T extends DataPackSerializable, U extends DataPackSerializedObject> Map<SpongeDataPackType<T, U>, List<T>> callRegisterDataPackValueEvent(SpongeDataPackType<T, U> type) {
        RegisterDataPackValueEventImpl<T, U> event = new RegisterDataPackValueEventImpl<T, U>(Cause.of(EventContext.empty(), this.game), this.game, type);
        this.game.getEventManager().post(event);
        return event.serializables();
    }

    private void reset() {
        this.serializables.clear();
        this.serializables.put((SpongeDataPackType)DataPackTypes.ADVANCEMENT, new ArrayList());
        this.serializables.put((SpongeDataPackType)DataPackTypes.RECIPE, new ArrayList());
        this.serializables.put((SpongeDataPackType)DataPackTypes.WORLD_TYPE, new ArrayList());
        this.serializables.put((SpongeDataPackType)DataPackTypes.WORLD, new ArrayList());
    }
}

