/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.potion;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.util.Constants;

public final class SpongePotionBuilder
extends AbstractDataBuilder<PotionEffect>
implements PotionEffect.Builder {
    private PotionEffectType potionType;
    private int duration;
    private int amplifier;
    private boolean isAmbient;
    private boolean showParticles;
    private boolean showIcon;

    public SpongePotionBuilder() {
        super(PotionEffect.class, 2);
        this.reset();
    }

    @Override
    public PotionEffect.Builder from(PotionEffect holder) {
        this.potionType = ((PotionEffect)Preconditions.checkNotNull((Object)holder)).getType();
        this.duration = holder.getDuration();
        this.amplifier = holder.getAmplifier();
        this.isAmbient = holder.isAmbient();
        this.showParticles = holder.showsParticles();
        this.showIcon = holder.showsIcon();
        return this;
    }

    @Override
    protected Optional<PotionEffect> buildContent(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container);
        if (!(container.contains(Constants.Item.Potions.POTION_TYPE) && container.contains(Constants.Item.Potions.POTION_DURATION) && container.contains(Constants.Item.Potions.POTION_AMPLIFIER) && container.contains(Constants.Item.Potions.POTION_AMBIANCE) && container.contains(Constants.Item.Potions.POTION_SHOWS_PARTICLES))) {
            return Optional.empty();
        }
        String effectName = container.getString(Constants.Item.Potions.POTION_TYPE).get();
        Optional optional = Sponge.getGame().registries().registry(RegistryTypes.POTION_EFFECT_TYPE).findValue(ResourceKey.resolve(effectName));
        if (!optional.isPresent()) {
            throw new InvalidDataException("The container has an invalid potion type name: " + effectName);
        }
        int duration = container.getInt(Constants.Item.Potions.POTION_DURATION).get();
        int amplifier = container.getInt(Constants.Item.Potions.POTION_AMPLIFIER).get();
        boolean ambience = container.getBoolean(Constants.Item.Potions.POTION_AMBIANCE).get();
        boolean particles = container.getBoolean(Constants.Item.Potions.POTION_SHOWS_PARTICLES).get();
        SpongePotionBuilder builder = new SpongePotionBuilder();
        return Optional.of(builder.potionType((PotionEffectType)optional.get()).showParticles(particles).duration(duration).amplifier(amplifier).ambient(ambience).build());
    }

    @Override
    public PotionEffect.Builder potionType(PotionEffectType potionEffectType) {
        Preconditions.checkNotNull((Object)potionEffectType, (Object)"Potion effect type cannot be null");
        this.potionType = potionEffectType;
        return this;
    }

    @Override
    public PotionEffect.Builder duration(int duration) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration must be greater than 0");
        this.duration = duration;
        return this;
    }

    @Override
    public PotionEffect.Builder amplifier(int amplifier) throws IllegalArgumentException {
        Preconditions.checkArgument((amplifier >= 0 ? 1 : 0) != 0, (Object)"Amplifier must not be negative");
        this.amplifier = amplifier;
        return this;
    }

    @Override
    public PotionEffect.Builder ambient(boolean ambience) {
        this.isAmbient = ambience;
        return this;
    }

    @Override
    public PotionEffect.Builder showParticles(boolean showParticles) {
        this.showParticles = showParticles;
        return this;
    }

    @Override
    public PotionEffect.Builder showIcon(boolean showIcon) {
        this.showIcon = showIcon;
        return this;
    }

    @Override
    public PotionEffect build() throws IllegalStateException {
        Preconditions.checkState((this.potionType != null ? 1 : 0) != 0, (Object)"Potion type has not been set");
        Preconditions.checkState((this.duration > 0 ? 1 : 0) != 0, (Object)"Duration has not been set");
        return (PotionEffect)new EffectInstance((Effect)this.potionType, this.duration, this.amplifier, this.isAmbient, this.showParticles, this.showIcon);
    }

    @Override
    public PotionEffect.Builder reset() {
        this.potionType = null;
        this.amplifier = 0;
        this.duration = 0;
        this.isAmbient = true;
        this.showParticles = true;
        this.showIcon = true;
        return this;
    }
}

