/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.ValidationTypes;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3d;

public class SpongeEntityArchetype
extends AbstractArchetype<EntityType, EntitySnapshot, org.spongepowered.api.entity.Entity>
implements EntityArchetype,
DataContainerHolder.Mutable {
    public static final ImmutableList<RawDataValidator> VALIDATORS = ImmutableList.of();
    private static final DataProviderLookup lookup = SpongeDataManager.getProviderRegistry().getProviderLookup(SpongeEntityArchetype.class);
    @Nullable
    private Vector3d position;

    SpongeEntityArchetype(SpongeEntityArchetypeBuilder builder) {
        super(builder.entityType, builder.compound != null ? builder.compound : (builder.entityData == null ? new CompoundNBT() : NBTTranslator.INSTANCE.translate(builder.entityData)));
    }

    @Override
    public EntityType<?> getType() {
        return (EntityType)this.type;
    }

    @Nullable
    public CompoundNBT getData() {
        return this.data;
    }

    @Override
    public DataProviderLookup getLookup() {
        return lookup;
    }

    public Optional<Vector3d> getPosition() {
        if (this.position != null) {
            return Optional.of(this.position);
        }
        if (!this.data.func_150297_b("Pos", 9)) {
            return Optional.empty();
        }
        try {
            ListNBT pos = this.data.func_150295_c("Pos", 6);
            double x = pos.func_150309_d(0);
            double y = pos.func_150309_d(1);
            double z = pos.func_150309_d(2);
            this.position = new Vector3d(x, y, z);
            return Optional.of(this.position);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public DataContainer data$getDataContainer() {
        return this.getEntityData();
    }

    @Override
    public void data$setDataContainer(DataContainer container) {
        this.data = NBTTranslator.INSTANCE.translate(container);
    }

    @Override
    public DataContainer getEntityData() {
        return NBTTranslator.INSTANCE.translateFrom(this.data);
    }

    @Override
    public Optional<org.spongepowered.api.entity.Entity> apply(ServerLocation location) {
        boolean requiresInitialSpawn;
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return Optional.empty();
        }
        ServerWorld spongeWorld = (ServerWorld)location.getWorld();
        net.minecraft.world.server.ServerWorld worldServer = (net.minecraft.world.server.ServerWorld)spongeWorld;
        Entity entity = ((net.minecraft.entity.EntityType)this.type).func_200721_a((World)worldServer);
        if (entity == null) {
            return Optional.empty();
        }
        entity.func_70107_b(location.getX(), location.getY(), location.getZ());
        if (this.data.func_74764_b("RequireInitialSpawn")) {
            requiresInitialSpawn = !this.data.func_74767_n("RequireInitialSpawn");
            this.data.func_82580_o("RequireInitialSpawn");
        } else {
            requiresInitialSpawn = true;
        }
        if (entity instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)entity;
            mobentity.field_70759_as = mobentity.field_70177_z;
            mobentity.field_70761_aq = mobentity.field_70125_A;
            if (requiresInitialSpawn) {
                mobentity.func_213386_a((IServerWorld)worldServer, worldServer.func_175649_E(mobentity.func_233580_cy_()), null, null, null);
            }
        }
        CompoundNBT mergedNbt = entity.func_189511_e(new CompoundNBT());
        UUID uniqueID = entity.func_110124_au();
        mergedNbt.func_197643_a(this.data);
        mergedNbt.func_82580_o("RequireInitialSpawn");
        mergedNbt.func_74778_a("WorldKey", location.getWorldKey().getFormatted());
        mergedNbt.func_186854_a("UUID", uniqueID);
        entity.func_70020_e(mergedNbt);
        entity.func_70107_b(location.getX(), location.getY(), location.getZ());
        org.spongepowered.api.entity.Entity spongeEntity = (org.spongepowered.api.entity.Entity)entity;
        ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
        entities.add(spongeEntity);
        SpawnType require = PhaseTracker.getCauseStackManager().getCurrentContext().require(EventContextKeys.SPAWN_TYPE);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(PhaseTracker.getCauseStackManager().getCurrentCause(), entities);
        if (!event.isCancelled()) {
            worldServer.func_217376_c(entity);
            return Optional.of(spongeEntity);
        }
        return Optional.empty();
    }

    @Override
    public EntitySnapshot toSnapshot(ServerLocation location) {
        SpongeEntitySnapshotBuilder builder = new SpongeEntitySnapshotBuilder();
        builder.entityType = (EntityType)this.type;
        CompoundNBT newCompound = this.data.func_74737_b();
        Vector3d pos = location.getPosition();
        newCompound.func_218657_a("Pos", (INBT)Constants.NBT.newDoubleNBTList(pos.getX(), pos.getY(), pos.getZ()));
        newCompound.func_74778_a("WorldKey", location.getWorldKey().getFormatted());
        builder.compound = newCompound;
        builder.worldKey = ((ServerWorld)location.getWorld()).getProperties().getKey();
        builder.position = pos;
        builder.rotation = this.getRotation();
        builder.scale = Vector3d.ONE;
        return builder.build();
    }

    private Vector3d getRotation() {
        ListNBT listnbt3 = this.data.func_150295_c("Rotation", 5);
        float rotationYaw = listnbt3.func_150308_e(0);
        float rotationPitch = listnbt3.func_150308_e(1);
        return new Vector3d(rotationPitch, rotationYaw, 0.0f);
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Constants.Sponge.EntityArchetype.ENTITY_TYPE, this.type).set(Constants.Sponge.EntityArchetype.ENTITY_DATA, this.getEntityData());
    }

    @Override
    protected ValidationType getValidationType() {
        return ValidationTypes.ENTITY.get();
    }

    @Override
    public EntityArchetype copy() {
        SpongeEntityArchetypeBuilder builder = new SpongeEntityArchetypeBuilder();
        builder.entityType = (EntityType)this.type;
        builder.entityData = NBTTranslator.INSTANCE.translate(this.data);
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeEntityArchetype that = (SpongeEntityArchetype)o;
        return Objects.equals(this.position, that.position);
    }

    @Override
    protected ImmutableList<RawDataValidator> getValidators() {
        return VALIDATORS;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.position);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("position", (Object)this.position).add("type", this.type).toString();
    }
}

